/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.v4.runtime.FailedState;
import org.neo4j.kernel.api.exceptions.Status;

class FailedStateIT
extends BoltStateMachineV4StateTestBase {
    FailedStateIT() {
    }

    @ParameterizedTest
    @MethodSource(value={"ignoredMessages"})
    void shouldIgnoreMessages(RequestMessage message) throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInFailedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(message, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
    }

    @Test
    void shouldMoveToInterruptedOnInterruptSignal() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInFailedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV4Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException, BoltConnectionFatality {
        BoltStateMachineV4 machine = this.getBoltStateMachineInFailedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
        Assertions.assertNull((Object)machine.state());
    }

    private BoltStateMachineV4 getBoltStateMachineInFailedState() throws BoltConnectionFatality, InterruptedException {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(FailedStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("error here")});
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)runMessage, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
        return machine;
    }

    private static Stream<RequestMessage> ignoredMessages() throws BoltIOException {
        return Stream.of(FailedStateIT.newDiscardMessage(2L), FailedStateIT.newPullMessage(2L), new RunMessage("A cypher query"), CommitMessage.COMMIT_MESSAGE, RollbackMessage.ROLLBACK_MESSAGE);
    }

    private static Stream<RequestMessage> illegalV4Messages() throws BoltIOException {
        return Stream.of(FailedStateIT.newHelloMessage(), new BeginMessage(), GoodbyeMessage.GOODBYE_MESSAGE, DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE);
    }
}

