/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AllOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class TransactionIT
extends BoltStateMachineV4StateTestBase {
    private static final Pattern BOOKMARK_PATTERN = Pattern.compile("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b:[0-9]+");

    TransactionIT() {
    }

    @Test
    void shouldHandleBeginCommit() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.run((String)"CREATE (n:InTx)"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.commit(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
    }

    @Test
    void shouldHandleBeginRollback() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.run((String)"CREATE (n:InTx)"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.rollback(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
    }

    @Test
    void shouldFailWhenOutOfOrderRollbackInAutoCommitMode() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        Assertions.assertThrows(BoltProtocolBreachFatality.class, () -> machine.process(BoltV4Messages.rollback(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler()));
    }

    @Test
    void shouldFailWhenOutOfOrderCommitInAutoCommitMode() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        Assertions.assertThrows(BoltProtocolBreachFatality.class, () -> machine.process(BoltV4Messages.commit(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler()));
    }

    @Test
    void shouldReceiveBookmarkOnCommit() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.run((String)"CREATE (a:Person)"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.commit(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithMetadata((String)"bookmark", (Pattern)BOOKMARK_PATTERN));
    }

    @Test
    void shouldNotReceiveBookmarkOnRollback() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.run((String)"CREATE (a:Person)"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.rollback(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithoutMetadata((String)"bookmark"));
    }

    @Test
    void shouldReadYourOwnWrites() throws Exception {
        BinaryLatch latch = new BinaryLatch();
        String bookmarkPrefix = null;
        try (BoltStateMachineV4 machine = this.newStateMachineAfterAuth();){
            BoltResponseRecorder recorder = new BoltResponseRecorder();
            machine.process(BoltV4Messages.run((String)"CREATE (n:A {prop:'one'})"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
            String bookmark = ((TextValue)recorder.nextResponse().metadata("bookmark")).stringValue();
            bookmarkPrefix = bookmark.split(":")[0];
        }
        long dbVersion = env.lastClosedTxId();
        Thread thread = new Thread(() -> {
            try (BoltStateMachineV4 machine = this.newStateMachineAfterAuth();){
                latch.await();
                BoltResponseRecorder recorder = new BoltResponseRecorder();
                machine.process(BoltV4Messages.run((String)"MATCH (n:A) SET n.prop = 'two'", (MapValue)VirtualValues.EMPTY_MAP), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
                machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
            }
            catch (Throwable connectionFatality) {
                throw new RuntimeException(connectionFatality);
            }
        });
        thread.start();
        long dbVersionAfterWrite = dbVersion + 1L;
        try (BoltStateMachineV4 machine = this.newStateMachineAfterAuth();){
            BoltResponseRecorder recorder = new BoltResponseRecorder();
            latch.release();
            String bookmark = bookmarkPrefix + ":" + dbVersionAfterWrite;
            machine.process(BoltV4Messages.begin((DatabaseIdRepository)env.databaseIdRepository(), (MapValue)ValueUtils.asMapValue(Collections.singletonMap("bookmarks", List.of(bookmark)))), (BoltResponseHandler)recorder);
            machine.process(BoltV4Messages.run((String)"MATCH (n:A) RETURN n.prop"), (BoltResponseHandler)recorder);
            machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
            machine.process(BoltV4Messages.commit(), (BoltResponseHandler)recorder);
            MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
            MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
            MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithRecord((Object[])new Object[]{"two"}));
            MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithMetadata((String)"bookmark", (Pattern)BOOKMARK_PATTERN));
        }
        thread.join();
    }

    @Test
    void shouldAllowNewRunAfterRunFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"INVALID QUERY"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        TransactionIT.resetReceived((BoltStateMachine)machine, recorder);
        machine.process(BoltV4Messages.run((String)"RETURN 2", (MapValue)VirtualValues.EMPTY_MAP), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Statement.SyntaxError));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithRecord((Object[])new Object[]{2L}));
        Assertions.assertEquals((int)0, (int)recorder.responseCount());
    }

    @Test
    void shouldAllowNewRunAfterStreamingFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"UNWIND [1, 0] AS x RETURN 1 / x"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        TransactionIT.resetReceived((BoltStateMachine)machine, recorder);
        machine.process(BoltV4Messages.run((String)"RETURN 2"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{BoltMatchers.containsRecord((Object[])new Object[]{1L}), BoltMatchers.failedWithStatus((Status)Status.Statement.ArithmeticError)}));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithRecord((Object[])new Object[]{2L}));
        Assertions.assertEquals((int)0, (int)recorder.responseCount());
    }

    @Test
    void shouldNotAllowNewRunAfterRunFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"INVALID QUERY"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.run(), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        Assertions.assertEquals((int)0, (int)recorder.responseCount());
    }

    @Test
    void shouldNotAllowNewRunAfterStreamingFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"UNWIND [1, 0] AS x RETURN 1 / x"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.run(), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Statement.ArithmeticError));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        Assertions.assertEquals((int)0, (int)recorder.responseCount());
    }

    @Test
    void shouldNotAllowNewTransactionAfterProtocolFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltMatchers.verifyKillsConnection(() -> machine.process(BoltV4Messages.commit(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler()));
        Assertions.assertFalse((boolean)machine.hasOpenStatement());
        Assertions.assertNull((Object)machine.state());
    }

    private static void resetReceived(BoltStateMachine machine, BoltResponseRecorder recorder) throws BoltConnectionFatality {
        machine.interrupt();
        machine.process(BoltV4Messages.reset(), (BoltResponseHandler)recorder);
    }
}

