/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.internal.helpers.HostnamePort;

@RunWith(value=Parameterized.class)
public class ConnectionIT {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), Neo4jWithSocket.withOptionalBoltEncryption());
    @Parameterized.Parameter
    public TransportConnection connection;
    private HostnamePort address;

    @Parameterized.Parameters
    public static Collection<TransportConnection> transports() {
        return Arrays.asList(new SecureSocketConnection(), new SocketConnection(), new SecureWebSocketConnection(), new WebSocketConnection());
    }

    @Before
    public void setUp() {
        this.address = this.server.lookupDefaultConnector();
    }

    @After
    public void cleanup() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldCloseConnectionOnInvalidHandshake() throws Exception {
        this.connection.connect(this.address);
        this.connection.send(new byte[]{-34, -83, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.exception.expect(IOException.class);
        this.connection.recv(4);
    }
}

