/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.function.Factory;
import org.neo4j.internal.helpers.HostnamePort;

@RunWith(value=Parameterized.class)
public class RequiredTransportEncryptionIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.REQUIRED));
    @Parameterized.Parameter(value=0)
    public Factory<TransportConnection> cf;
    private HostnamePort address;
    private TransportConnection client;
    private TransportTestUtil util;

    @Parameterized.Parameters
    public static Collection<Factory<TransportConnection>> transports() {
        return Arrays.asList(SocketConnection::new, WebSocketConnection::new);
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil();
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldCloseUnencryptedConnectionOnHandshakeWhenEncryptionIsRequired() throws Throwable {
        this.client.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }
}

