/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.v3.messaging.response.FailureMessage;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class AuthenticationIT
extends AbstractBoltTransportsTest {
    protected EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    protected final AssertableLogProvider logProvider = new AssertableLogProvider();
    protected Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    private HostnamePort address;

    protected TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        return new TestDatabaseManagementServiceBuilder().setUserLogProvider((LogProvider)this.logProvider);
    }

    @Override
    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            super.getSettingsFunction().accept((Map<Setting<?>, Object>)settings);
            settings.put(GraphDatabaseSettings.auth_enabled, true);
        };
    }

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldRespondWithCredentialsExpiredOnFirstUse() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"credentials_expired"), (Matcher)Matchers.equalTo((Object)true)), Matchers.hasKey((Object)"server"), Matchers.hasKey((Object)"connection_id")}))}));
        this.verifyConnectionOpen();
    }

    private void verifyConnectionOpen() throws IOException {
        this.connection.send(this.util.defaultReset());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailIfWrongCredentials() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
        org.neo4j.test.assertion.Assert.assertEventually(ignore -> "Matching log call not found in\n" + this.logProvider.serialize(), this::authFailureLoggedToUserLog, (Matcher)CoreMatchers.is((Object)true), (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean authFailureLoggedToUserLog() {
        String boltPackageName = BoltServer.class.getPackage().getName();
        return this.logProvider.containsMatchingLogCall(AssertableLogProvider.inLog((Matcher)CoreMatchers.containsString((String)boltPackageName)).warn(CoreMatchers.containsString((String)"The client is unauthorized due to authentication failure.")));
    }

    @Test
    public void shouldFailIfWrongCredentialsFollowingSuccessfulLogin() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "secret"), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenWrongType() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", Collections.singletonList("neo4j"), "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingKey() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "this-should-have-been-credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `credentials`")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingScheme() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `scheme`")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenUnknownScheme() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "unknown"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, scheme 'unknown' is not supported.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailDifferentlyIfTooManyFailedAuthAttempts() throws Exception {
        long timeout = System.currentTimeMillis() + 60000L;
        FailureMessage failureMessage = null;
        block5: while (failureMessage == null) {
            int i;
            if (System.currentTimeMillis() > timeout) {
                Assert.fail((String)"Timed out waiting for the authentication failure to occur.");
            }
            ExecutorService executor = Executors.newFixedThreadPool(10);
            ArrayList<CompletableFuture<FailureMessage>> futures = new ArrayList<CompletableFuture<FailureMessage>>();
            for (i = 0; i < 10; ++i) {
                futures.add(CompletableFuture.supplyAsync(this::collectAuthFailureOnFailedAuth, executor));
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                for (i = 0; i < futures.size(); ++i) {
                    FailureMessage recordedMessage = (FailureMessage)((CompletableFuture)futures.get(i)).get();
                    if (recordedMessage == null) continue;
                    failureMessage = recordedMessage;
                    continue block5;
                }
            }
            catch (TimeoutException timeoutException) {}
            continue;
            finally {
                executor.shutdown();
            }
        }
        MatcherAssert.assertThat((Object)failureMessage.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.AuthenticationRateLimit));
        MatcherAssert.assertThat((Object)failureMessage.message(), (Matcher)CoreMatchers.containsString((String)"The client has provided incorrect authentication details too many times in a row."));
    }

    @Test
    public void shouldBeAbleToChangePasswordUsingSystemCommand() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"credentials_expired"), (Matcher)Matchers.equalTo((Object)true)), Matchers.hasKey((Object)"server"), Matchers.hasKey((Object)"connection_id")}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "secret"), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailWhenReusingTheSamePassword() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"credentials_expired"), (Matcher)Matchers.equalTo((Object)true)), Matchers.hasKey((Object)"server"), Matchers.hasKey((Object)"connection_id")}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "neo4j"), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, (String)"Old password and new password cannot be the same.")}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "abc"), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailWhenSubmittingEmptyPassword() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"credentials_expired"), (Matcher)Matchers.equalTo((Object)true)), Matchers.hasKey((Object)"server"), Matchers.hasKey((Object)"connection_id")}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", ""), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, (String)"A password cannot be empty.")}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "abc"), "system"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldNotBeAbleToReadWhenPasswordChangeRequired() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"credentials_expired"), (Matcher)Matchers.equalTo((Object)true)), Matchers.hasKey((Object)"server"), Matchers.hasKey((Object)"connection_id")}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("MATCH (n) RETURN n"));
        Matcher expectedFailureMessage = MessageMatchers.msgFailure((Status)Status.Security.CredentialsExpired, (String)"The credentials you provided were valid, but must be changed before you can use this instance.");
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesWithOptionalPrecedingMessages(new Pair[]{Pair.of((Object)MessageMatchers.msgSuccess(), (Object)TransportTestUtil.ResponseMatcherOptionality.OPTIONAL), Pair.of((Object)expectedFailureMessage, (Object)TransportTestUtil.ResponseMatcherOptionality.REQUIRED)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }

    private FailureMessage collectAuthFailureOnFailedAuth() {
        FailureMsgMatcher failureRecorder = new FailureMsgMatcher();
        TransportConnection connection = null;
        try {
            connection = this.newConnection();
            connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN", "scheme", "basic"})));
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{failureRecorder}));
            MatcherAssert.assertThat((Object)connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return failureRecorder.specialMessage;
    }

    class FailureMsgMatcher
    extends TypeSafeMatcher<ResponseMessage> {
        FailureMessage specialMessage;

        FailureMsgMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("FAILURE");
        }

        protected boolean matchesSafely(ResponseMessage t) {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(FailureMessage.class));
            FailureMessage msg = (FailureMessage)t;
            if (!msg.status().equals(Status.Security.Unauthorized) || !msg.message().contains("The client is unauthorized due to authentication failure.")) {
                this.specialMessage = msg;
            }
            return true;
        }
    }
}

