/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.net.SocketException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.matchers.CommonMatchers;
import org.neo4j.test.rule.OtherThreadRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class BoltThrottleMaxDurationIT {
    private AssertableLogProvider logProvider;
    private EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    @Rule
    public OtherThreadRule<Void> otherThread = new OtherThreadRule(5L, TimeUnit.MINUTES);
    @Parameterized.Parameter
    public Factory<TransportConnection> cf;
    private HostnamePort address;
    private TransportConnection client;
    private TransportTestUtil util;

    @Parameterized.Parameters
    public static Collection<Factory<TransportConnection>> transports() {
        return Arrays.asList(SocketConnection::new, SecureSocketConnection::new);
    }

    protected TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder();
        this.logProvider = new AssertableLogProvider();
        factory.setInternalLogProvider((LogProvider)this.logProvider);
        return factory;
    }

    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            settings.put(GraphDatabaseSettings.bolt_outbound_buffer_throttle_max_duration, Duration.ofSeconds(30L));
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        };
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil();
    }

    @After
    public void after() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void sendingButNotReceivingClientShouldBeKilledWhenWriteThrottleMaxDurationIsReached() throws Exception {
        int numberOfRunDiscardPairs = 10000;
        String largeString = StringUtils.repeat((String)" ", (int)8192);
        this.client.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.client, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.client, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        Future sender = this.otherThread.execute(state -> {
            for (int i = 0; i < numberOfRunDiscardPairs; ++i) {
                this.client.send(this.util.defaultRunAutoCommitTx("RETURN $data as data", ValueUtils.asMapValue(Collections.singletonMap("data", largeString))));
            }
            return null;
        });
        try {
            this.otherThread.get().awaitFuture(sender);
            Assert.fail((String)"should throw ExecutionException instead");
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(SocketException.class));
        }
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((Matcher)Matchers.containsString((String)BoltConnection.class.getPackage().getName())).error(CoreMatchers.startsWith((String)"Unexpected error detected in bolt session"), Matchers.hasProperty((String)"cause", (Matcher)CommonMatchers.matchesExceptionMessage((Matcher)CoreMatchers.containsString((String)"will be closed because the client did not consume outgoing buffers for "))))});
    }
}

