/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.operator.OperatorCreationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public class CertificatesIT {
    private static File keyFile;
    private static File certFile;
    private static SelfSignedCertificateFactory certFactory;
    private static TransportTestUtil util;
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> {
        SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
        settings.put(policy.enabled, true);
        settings.put(policy.public_certificate, certFile.toPath().toAbsolutePath());
        settings.put(policy.private_key, keyFile.toPath().toAbsolutePath());
        settings.put(BoltConnector.enabled, true);
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
    });

    @Test
    public void shouldUseConfiguredCertificate() throws Exception {
        SecureSocketConnection connection = new SecureSocketConnection();
        try {
            connection.connect(this.server.lookupConnector("bolt")).send(util.defaultAcceptedVersions());
            Set certificatesSeen = connection.getServerCertificatesSeen();
            MatcherAssert.assertThat((Object)certificatesSeen, (Matcher)Matchers.contains((Object[])new X509Certificate[]{this.loadCertificateFromDisk()}));
        }
        finally {
            connection.disconnect();
        }
    }

    private X509Certificate loadCertificateFromDisk() throws CertificateException, IOException {
        X509Certificate[] certificates = PkiUtils.loadCertificates((File)certFile);
        MatcherAssert.assertThat((Object)certificates.length, (Matcher)CoreMatchers.equalTo((Object)1));
        return certificates[0];
    }

    @BeforeClass
    public static void setUp() throws IOException, GeneralSecurityException, OperatorCreationException {
        certFactory = new SelfSignedCertificateFactory();
        keyFile = File.createTempFile("key", "pem");
        certFile = File.createTempFile("key", "pem");
        keyFile.deleteOnExit();
        certFile.deleteOnExit();
        keyFile.delete();
        certFile.delete();
        certFactory.createSelfSignedCertificate(certFile, keyFile, "my.domain");
        util = new TransportTestUtil();
    }
}

