/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.function.Factory;

@RunWith(value=Parameterized.class)
public class RejectTransportEncryptionIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED));
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public Factory<TransportConnection> cf;
    @Parameterized.Parameter(value=1)
    public Exception expected;
    private TransportConnection client;
    private TransportTestUtil util;

    @Parameterized.Parameters
    public static Collection<Object[]> transports() {
        return Arrays.asList({SecureWebSocketConnection::new, new IOException("Failed to connect to the server within 10 seconds")}, {SecureSocketConnection::new, new IOException(SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9) ? "Remote host terminated the handshake" : "Remote host closed connection during handshake")});
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.util = new TransportTestUtil();
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldRejectConnectionAfterHandshake() throws Throwable {
        this.exception.expect(this.expected.getClass());
        this.exception.expectMessage(this.expected.getMessage());
        this.client.connect(this.server.lookupDefaultConnector()).send(this.util.defaultAcceptedVersions());
    }
}

