/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.StreamMatchers;
import org.neo4j.bolt.testing.TestNotification;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.storable.Values;

public class TransportSessionIT
extends AbstractBoltTransportsTest {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getSettingsFunction());
    private HostnamePort address;

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldNegotiateProtocolVersion() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
    }

    @Test
    public void shouldReturnNilOnNoApplicableVersion() throws Throwable {
        this.connection.connect(this.address).send(this.util.acceptedVersions(1337L, 0L, 0L, 0L));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 0}));
    }

    @Test
    public void shouldRunSimpleStatement() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryFieldMatcher, Matchers.hasKey((Object)"t_first")})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L)), CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L)), CoreMatchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)3L)), CoreMatchers.equalTo((Object)Values.longValue((long)9L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryTypeMatcher, Matchers.hasKey((Object)"t_last")}))}));
    }

    @Test
    public void shouldRespondWithMetadataToDiscardAll() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTxWithoutResult("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryFieldsMatcher, Matchers.hasKey((Object)"t_first")})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryTypeMatcher, Matchers.hasKey((Object)"t_last")}))}));
    }

    @Test
    public void shouldBeAbleToRunQueryAfterAckFailure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("QINVALID"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("Invalid input 'Q': expected <init> (line 1, column 1 (offset: 0))%n\"QINVALID\"%n ^", new Object[0])), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldRunProcedure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n:Test {age: 2}) RETURN n.age AS age"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher ageMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("age")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{ageMatcher, Matchers.hasKey((Object)"t_first")})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L))})), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("CALL db.labels() YIELD label"));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("label")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryFieldsMatcher, Matchers.hasKey((Object)"t_first")})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.stringValue((String)"Test"))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedNodes() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n:Test) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("n")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryFieldsMatcher, Matchers.hasKey((Object)"t_first")}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedRelationships() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("r")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{entryFieldsMatcher, Matchers.hasKey((Object)"t_first")}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 11, 177, 113, 145, 181, 82, 0, 0, 1, 129, 84, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldNotLeakStatsToNextStatement() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n)"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        Matcher typeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{typeMatcher, Matchers.hasKey((Object)"t_last")}))}));
    }

    @Test
    public void shouldSendNotifications() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.hasNotification((Notification)new TestNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, new InputPosition(17, 1, 18)))}));
    }

    private byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Test
    public void shouldFailNicelyOnNullKeysInMap() throws Throwable {
        HashMap params = new HashMap();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("RETURN {p}", ValueUtils.asMapValue(params)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailNicelyWhenDroppingUnknownIndex() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("DROP INDEX on :Movie12345(id)"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Schema.IndexDropFailed, (String)"Unable to drop index on :Movie12345(id). There is no such index."), MessageMatchers.msgIgnored()}));
    }
}

