/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackedOutputArray;
import org.neo4j.bolt.packstream.example.Edges;
import org.neo4j.bolt.packstream.example.Nodes;
import org.neo4j.bolt.packstream.example.Paths;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.PathValue;

public class UnsupportedStructTypesV1V2IT
extends AbstractBoltTransportsTest {
    public static final byte DEFAULT_SIGNATURE = 16;
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getSettingsFunction());

    @Before
    public void setup() throws Exception {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldFailWhenNullKeyIsSent() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createMsgWithNullKey()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenDuplicateKey() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createMsgWithDuplicateKey()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Duplicate map key `key1`.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenNodeIsSentWithRun() throws Exception {
        this.testFailureWithV1Value((AnyValue)Nodes.ALICE, "Node");
    }

    @Test
    public void shouldFailWhenRelationshipIsSentWithRun() throws Exception {
        this.testFailureWithV1Value((AnyValue)Edges.ALICE_KNOWS_BOB, "Relationship");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailWhenPathIsSentWithRun() throws Exception {
        for (PathValue path : Paths.ALL_PATHS) {
            try {
                this.testFailureWithV1Value((AnyValue)path, "Path");
            }
            finally {
                this.reconnect();
            }
        }
    }

    @Test
    public void shouldTerminateConnectionWhenUnknownMessageIsSent() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createUnknownMsg()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void testFailureWithV1Value(AnyValue value, String description) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWithUnknownValue(value)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Statement.TypeError, (String)(description + " values cannot be unpacked with this version of bolt."))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWithUnknownValue(AnyValue value) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.pack(value);
        return out.bytes();
    }

    private byte[] createUnknownMsg() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(0, (byte)16);
        return out.bytes();
    }

    private byte[] createMsgWithNullKey() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithNullKey(packer);
        return out.bytes();
    }

    private byte[] createMsgWithDuplicateKey() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithDuplicateKey(packer);
        return out.bytes();
    }

    private static void packMapWithNullKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack(ValueUtils.of(null));
        packer.pack(ValueUtils.of(null));
        packer.pack("value1");
    }

    private static void packMapWithDuplicateKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack("value1");
        packer.pack("key1");
        packer.pack("value2");
    }
}

