/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.StreamMatchers;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkWithDatabaseId;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class BoltV4TransportIT {
    private static final String USER_AGENT = "TestClient/4.0";
    @Rule
    public final Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), Neo4jWithSocket.withOptionalBoltEncryption());
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;
    @Parameterized.Parameter
    public Class<? extends TransportConnection> connectionClass;

    @Parameterized.Parameters(name="{0}")
    public static List<Class<? extends TransportConnection>> transports() {
        return Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    }

    @Before
    public void setUp() throws Exception {
        this.address = this.server.lookupDefaultConnector();
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterAutoCommitTransaction() throws Throwable {
        this.negotiateBoltV4();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"bookmark", (Object)expectedBookmark)}))}));
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterExplicitTransaction() throws Throwable {
        this.negotiateBoltV4();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.hasEntry((Object)"bookmark", (Object)expectedBookmark))}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"bookmark", (Object)expectedBookmark)}))}));
    }

    @Test
    public void shouldStreamWhenStatementIdNotProvided() throws Exception {
        this.negotiateBoltV4();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(30, 40) AS x RETURN x")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"qid"), (Matcher)Matchers.equalTo((Object)0L)), Matchers.hasKey((Object)"fields"), Matchers.hasKey((Object)"t_first")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 5L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)30L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)31L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)32L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)33L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)34L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)35L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)36L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)37L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)38L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)39L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 10L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)40L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.hasKey((Object)"has_more")), Matchers.hasKey((Object)"t_last")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldSendAndReceiveStatementIds() throws Exception {
        this.negotiateBoltV4();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(1, 10) AS x RETURN x")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"qid"), (Matcher)Matchers.equalTo((Object)0L)), Matchers.hasKey((Object)"fields"), Matchers.hasKey((Object)"t_first")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)2L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)3L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(11, 20) AS x RETURN x")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"qid"), (Matcher)Matchers.equalTo((Object)1L)), Matchers.hasKey((Object)"fields"), Matchers.hasKey((Object)"t_first")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 1L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)11L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)12L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(21, 30) AS x RETURN x")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"qid"), (Matcher)Matchers.equalTo((Object)2L)), Matchers.hasKey((Object)"fields"), Matchers.hasKey((Object)"t_first")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 4L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)21L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)22L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)23L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)24L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(31, 40) AS x RETURN x")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"qid"), (Matcher)Matchers.equalTo((Object)3L)), Matchers.hasKey((Object)"fields"), Matchers.hasKey((Object)"t_first")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 1L, "qid", 3L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)31L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 0L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)5L))})), MessageMatchers.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 9L, "qid", 3L})))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)32L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)33L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)34L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)35L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)36L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)37L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)38L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)39L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.longValue((long)40L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.hasKey((Object)"has_more")), Matchers.hasKey((Object)"t_last")}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    private void negotiateBoltV4() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(4L, 0L, 0L, 0L));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 4}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    private long getLastClosedTransactionId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        TransactionIdStore txIdStore = (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    private NamedDatabaseId getDatabaseId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        Database database = (Database)resolver.resolveDependency(Database.class);
        return database.getNamedDatabaseId();
    }
}

