/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.v4.BoltProtocolV4;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class BoltConnectionAuthIT {
    private static final BoltChannel BOLT_CHANNEL = BoltTestUtil.newTestBoltChannel((String)"conn-v4-test-boltchannel-id");
    @RegisterExtension
    static final SessionExtension env = new SessionExtension().withAuthEnabled(true);

    BoltConnectionAuthIT() {
    }

    protected BoltStateMachineV4 newStateMachine() {
        return (BoltStateMachineV4)env.newMachine(BoltProtocolV4.VERSION, BOLT_CHANNEL);
    }

    @Test
    void shouldGiveCredentialsExpiredStatusOnExpiredCredentials() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        RequestMessage hello = BoltV4Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"));
        machine.process(hello, (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.run((String)"CREATE ()"), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeededWithMetadata((String)"credentials_expired", (AnyValue)Values.TRUE));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Security.CredentialsExpired));
    }

    @Test
    void shouldGiveKernelVersionOnInit() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        String version = "Neo4j/" + Version.getNeo4jVersion();
        RequestMessage hello = BoltV4Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"));
        machine.process(hello, (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.run((String)"CREATE ()"), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeededWithMetadata((String)"server", (AnyValue)Values.stringValue((String)version)));
    }

    @Test
    void shouldCloseConnectionAfterAuthenticationFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        RequestMessage hello = BoltV4Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"j4oen"));
        BoltConditions.verifyKillsConnection(() -> BoltConnectionAuthIT.lambda$shouldCloseConnectionAfterAuthenticationFailure$0((BoltStateMachine)machine, hello, recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Security.Unauthorized));
    }

    private static /* synthetic */ void lambda$shouldCloseConnectionAfterAuthenticationFailure$0(BoltStateMachine machine, RequestMessage hello, BoltResponseRecorder recorder) throws BoltConnectionFatality {
        machine.process(hello, (BoltResponseHandler)recorder);
    }
}

