/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.BoltV3Messages;
import org.neo4j.bolt.v3.runtime.BoltStateMachineV3StateTestBase;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;

class ConnectedStateIT
extends BoltStateMachineV3StateTestBase {
    ConnectedStateIT() {
    }

    @Test
    void shouldHandleHelloMessage() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ConnectedStateIT.newHelloMessage(), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithMetadata((String)"server", (String)("Neo4j/" + Version.getNeo4jVersion())));
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithMetadata((String)"connection_id", (String)"conn-v3-test-boltchannel-id"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV2Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException {
        BoltStateMachineV3 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltConditions.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Request.Invalid));
        org.junit.jupiter.api.Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() {
        return BoltV3Messages.supported().filter(e -> !e.equals(BoltV3Messages.hello()));
    }

    private static Stream<RequestMessage> illegalV4Messages() throws BoltIOException {
        return BoltV3Messages.unsupported();
    }
}

