/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public class RoutingConnectorCertificatesIT {
    private static File externalKeyFile;
    private static File externalCertFile;
    private static File internalKeyFile;
    private static File internalCertFile;
    private static SelfSignedCertificateFactory certFactory;
    private static TransportTestUtil util;
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> {
        SslPolicyConfig externalPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
        settings.put(externalPolicy.enabled, true);
        settings.put(externalPolicy.public_certificate, externalCertFile.toPath().toAbsolutePath());
        settings.put(externalPolicy.private_key, externalKeyFile.toPath().toAbsolutePath());
        SslPolicyConfig internalPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER);
        settings.put(internalPolicy.enabled, true);
        settings.put(internalPolicy.client_auth, ClientAuth.NONE);
        settings.put(internalPolicy.public_certificate, internalCertFile.toPath().toAbsolutePath());
        settings.put(internalPolicy.private_key, internalKeyFile.toPath().toAbsolutePath());
        settings.put(BoltConnector.enabled, true);
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        settings.put(GraphDatabaseSettings.routing_enabled, true);
        settings.put(GraphDatabaseSettings.routing_listen_address, new SocketAddress("localhost", 0));
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseConfiguredCertificate() throws Exception {
        SecureSocketConnection externalConnection = new SecureSocketConnection();
        SecureSocketConnection internalConnection = new SecureSocketConnection();
        try {
            externalConnection.connect(this.server.lookupConnector("bolt")).send(util.defaultAcceptedVersions());
            internalConnection.connect(this.server.lookupConnector("bolt-internal")).send(util.defaultAcceptedVersions());
            Set externalCertificatesSeen = externalConnection.getServerCertificatesSeen();
            Set internalCertificatesSeen = internalConnection.getServerCertificatesSeen();
            Assertions.assertThat((Iterable)externalCertificatesSeen).isNotEqualTo((Object)internalCertificatesSeen);
            Assertions.assertThat((Iterable)externalCertificatesSeen).containsExactly((Object[])new X509Certificate[]{this.loadCertificateFromDisk(externalCertFile)});
            Assertions.assertThat((Iterable)internalCertificatesSeen).containsExactly((Object[])new X509Certificate[]{this.loadCertificateFromDisk(internalCertFile)});
        }
        finally {
            externalConnection.disconnect();
            internalConnection.disconnect();
        }
    }

    private X509Certificate loadCertificateFromDisk(File certFile) throws CertificateException, IOException {
        X509Certificate[] certificates = PkiUtils.loadCertificates((File)certFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        return certificates[0];
    }

    @BeforeClass
    public static void setUp() throws IOException, GeneralSecurityException, OperatorCreationException {
        certFactory = new SelfSignedCertificateFactory();
        externalKeyFile = File.createTempFile("key", "pem");
        externalCertFile = File.createTempFile("key", "pem");
        externalKeyFile.deleteOnExit();
        externalCertFile.deleteOnExit();
        externalKeyFile.delete();
        externalCertFile.delete();
        certFactory.createSelfSignedCertificate(externalCertFile, externalKeyFile, "my.domain");
        internalKeyFile = File.createTempFile("key", "pem");
        internalCertFile = File.createTempFile("key", "pem");
        internalKeyFile.deleteOnExit();
        internalCertFile.deleteOnExit();
        internalKeyFile.delete();
        internalCertFile.delete();
        certFactory.createSelfSignedCertificate(internalCertFile, internalKeyFile, "my.domain");
        util = new TransportTestUtil();
    }
}

