/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.messaging.RecordingByteChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.packstream.BufferedChannelOutput;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackStream;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class TransportErrorIT
extends AbstractBoltTransportsTest {
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @AfterEach
    public void cleanup() {
        this.server.shutdownDatabase();
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleIncorrectFraming(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        byte[] truncated = MessageConditions.serialize((Neo4jPack)this.util.getNeo4jPack(), (RequestMessage[])new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")});
        truncated = Arrays.copyOf(truncated, truncated.length - 12);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, (byte[][])new byte[][]{truncated}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleMessagesWithIncorrectFields(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput((WritableByteChannel)rawData));
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN 1");
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, (byte[][])new byte[][]{invalidMessage}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleUnknownMessages(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        RecordingByteChannel rawData = new RecordingByteChannel();
        PackStream.Packer packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput((WritableByteChannel)rawData));
        packer.packStructHeader(1, (byte)102);
        packer.pack(1234L);
        packer.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, (byte[][])new byte[][]{invalidMessage}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleUnknownMarkerBytes(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        RecordingByteChannel rawData = new RecordingByteChannel();
        BufferedChannelOutput out = new BufferedChannelOutput((WritableByteChannel)rawData);
        PackStream.Packer packer = new PackStream.Packer((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        out.writeByte((byte)-57);
        out.flush();
        byte[] invalidMessage = rawData.getBytes();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(32, (byte[][])new byte[][]{invalidMessage}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }
}

