/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.runtime.scheduling.BoltConnectionReadLimiter;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
class BoltChannelAutoReadLimiterIT {
    @Inject
    private Neo4jWithSocket server;
    private AssertableLogProvider logProvider;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    BoltChannelAutoReadLimiterIT() {
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        this.server.setGraphDatabaseFactory(this.getTestGraphDatabaseFactory());
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.connection = new SocketConnection();
        this.util = new TransportTestUtil();
        BoltChannelAutoReadLimiterIT.installSleepProcedure(this.server.graphDatabaseService());
    }

    @AfterEach
    public void cleanup() {
        this.server.shutdownDatabase();
    }

    protected TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder();
        this.logProvider = new AssertableLogProvider();
        factory.setInternalLogProvider((LogProvider)this.logProvider);
        return factory;
    }

    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled, false);
    }

    @Test
    public void largeNumberOfSlowRunningJobsShouldChangeAutoReadState() throws Exception {
        int i;
        int numberOfRunDiscardPairs = 1000;
        String largeString = " ".repeat(8192);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            this.connection.send(this.util.defaultRunAutoCommitTxWithoutResult("CALL boltissue.sleep( $data )", ValueUtils.asMapValue(Collections.singletonMap("data", largeString))));
        }
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
        }
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(BoltConnectionReadLimiter.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"disabled", "enabled"});
    }

    private static void installSleepProcedure(GraphDatabaseService db) throws ProcedureException {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        ((GlobalProcedures)dbApi.getDependencyResolver().resolveDependency(GlobalProcedures.class)).register((CallableProcedure)new CallableProcedure.BasicProcedure(ProcedureSignature.procedureSignature((String[])new String[]{"boltissue", "sleep"}).in("data", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out(ProcedureSignature.VOID).build()){

            public RawIterator<AnyValue[], ProcedureException> apply(Context context, AnyValue[] objects, ResourceTracker resourceTracker) throws ProcedureException {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Interrupted", new Object[0]);
                }
                return RawIterator.empty();
            }
        });
    }
}

