/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.BoltV3TransportBase;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GoodbyeMessageIT
extends BoltV3TransportBase {
    @Test
    public void shouldCloseConnectionInConnected() throws Throwable {
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 2L, 1L, 0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInReady() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInStreaming() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))).containsKey((Object)"t_first"))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
        Assertions.assertThat((Object)this.server).satisfies(GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldCloseConnectionInFailed() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("I am sending you to failed state!")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("Invalid input 'I': expected <init> (line 1, column 1 (offset: 0))%n\"I am sending you to failed state!\"%n ^", new Object[0]))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInTxReady() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
        Assertions.assertThat((Object)this.server).satisfies(GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldCloseConnectionInTxStreaming() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared")))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
        Assertions.assertThat((Object)this.server).satisfies(GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldDropConnectionImmediatelyAfterGoodbye() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE, ResetMessage.INSTANCE, new RunMessage("RETURN 1")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.serverImmediatelyDisconnects());
    }

    private static Condition<Neo4jWithSocket> eventuallyClosesTransaction() {
        return new Condition(server -> {
            BooleanSupplier condition = () -> GoodbyeMessageIT.getActiveTransactions(server).size() == 0;
            try {
                Predicates.await((BooleanSupplier)condition, (long)2L, (TimeUnit)TimeUnit.SECONDS);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, "Eventually close all transactions", new Object[0]);
    }

    private static Set<KernelTransactionHandle> getActiveTransactions(Neo4jWithSocket server) {
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)server.graphDatabaseService();
        return ((KernelTransactions)gdb.getDependencyResolver().resolveDependency(KernelTransactions.class)).activeTransactions();
    }
}

