/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.scheduling.ExecutorBoltScheduler;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.SpiedAssertableLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ResetFuzzIT {
    private static final int TEST_EXECUTION_TIME = 2000;
    private final int seed = new Random().nextInt();
    private final Random rand = new Random(this.seed);
    private final AssertableLogProvider internalLogProvider = new SpiedAssertableLogProvider(ExecutorBoltScheduler.class);
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final Neo4jWithSocket server = new Neo4jWithSocket(this.getTestGraphDatabaseFactory(), () -> TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fsRule.get()), ResetFuzzIT.getSettingsFunction());
    private final TransportTestUtil util = new TransportTestUtil();
    private HostnamePort address;
    private static final String SHORT_QUERY_1 = "CREATE (n:Node {name: 'foo', occupation: 'bar'})";
    private static final String SHORT_QUERY_2 = "MATCH (n:Node {name: 'foo'}) RETURN count(n)";
    private static final String SHORT_QUERY_3 = "RETURN 1";
    private static final String LONG_QUERY = "UNWIND range(0, 10000000) AS i CREATE (n:Node {idx: i}) DELETE n";
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.fsRule).around((TestRule)this.server);

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @After
    public void tearDown() {
        this.userLogProvider.print(System.out);
        this.internalLogProvider.print(System.out);
    }

    @Test
    public void shouldTerminateAutoCommitQuery() throws Exception {
        List<Pair<byte[], Integer>> sequences = Arrays.asList(Pair.of((Object)this.util.defaultRunAutoCommitTx(SHORT_QUERY_1), (Object)2), Pair.of((Object)this.util.defaultRunAutoCommitTxWithoutResult(SHORT_QUERY_2), (Object)2), Pair.of((Object)this.util.chunk(new RequestMessage[]{BoltV4Messages.run((String)SHORT_QUERY_3)}), (Object)1));
        this.execute(sequences);
    }

    @Test
    public void shouldTerminateLongRunningAutoCommitQuery() throws Exception {
        List<Pair<byte[], Integer>> sequences = Collections.singletonList(Pair.of((Object)this.util.defaultRunAutoCommitTxWithoutResult(LONG_QUERY), (Object)2));
        this.execute(sequences);
    }

    @Test
    public void shouldTerminateQueryInExplicitTransaction() throws Exception {
        List<Pair<byte[], Integer>> sequences = Arrays.asList(Pair.of((Object)this.util.defaultRunExplicitCommitTxAndRollBack(SHORT_QUERY_1), (Object)4), Pair.of((Object)this.util.defaultRunExplicitCommitTxAndCommit(SHORT_QUERY_2), (Object)4), Pair.of((Object)this.util.chunk(new RequestMessage[]{BoltV4Messages.begin(), BoltV4Messages.run((String)SHORT_QUERY_3), BoltV4Messages.pullAll()}), (Object)3), Pair.of((Object)this.util.chunk(new RequestMessage[]{BoltV4Messages.begin(), BoltV4Messages.run((String)SHORT_QUERY_1)}), (Object)2), Pair.of((Object)this.util.chunk(new RequestMessage[]{BoltV4Messages.begin()}), (Object)1));
        this.execute(sequences);
    }

    @Test
    public void shouldTerminateLongRunningQueryInExplicitTransaction() throws Exception {
        List<Pair<byte[], Integer>> sequences = Collections.singletonList(Pair.of((Object)this.util.defaultRunExplicitCommitTxAndRollBack(LONG_QUERY), (Object)4));
        this.execute(sequences);
    }

    private void execute(List<Pair<byte[], Integer>> sequences) throws Exception {
        TransportConnection connection = this.connectAndAuthenticate();
        long deadline = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < deadline) {
            int sent = this.dispatchRandomSequenceOfMessages(connection, sequences);
            this.assertResetWorks(connection, sent);
        }
    }

    private void assertResetWorks(TransportConnection connection, int sent) throws IOException {
        connection.send(this.util.defaultReset());
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(sent, new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private int dispatchRandomSequenceOfMessages(TransportConnection connection, List<Pair<byte[], Integer>> sequences) throws IOException {
        Pair<byte[], Integer> pair = sequences.get(this.rand.nextInt(sequences.size()));
        connection.send((byte[])pair.first());
        return (Integer)pair.other();
    }

    private TransportConnection connectAndAuthenticate() throws Exception {
        SocketConnection connection = new SocketConnection();
        connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        return connection;
    }

    private TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder();
        factory.setInternalLogProvider((LogProvider)this.internalLogProvider);
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
        return factory;
    }

    private static Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
            settings.put(BoltConnectorInternalSettings.unsupported_thread_pool_queue_size, -1);
            settings.put(BoltConnector.thread_pool_min_size, 1);
            settings.put(BoltConnector.thread_pool_max_size, 1);
        };
    }
}

