/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class RejectTransportEncryptionIT {
    @Inject
    private Neo4jWithSocket server;
    private TransportConnection client;
    private TransportTestUtil util;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED));
        this.server.init(testInfo);
    }

    @AfterEach
    public void cleanup() {
        this.server.shutdownDatabase();
    }

    public static Stream<Arguments> transportFactory() {
        return Stream.of(Arguments.of((Object[])new Object[]{SecureWebSocketConnection.class, new IOException("Failed to connect to the server within 30 seconds")}), Arguments.of((Object[])new Object[]{SecureSocketConnection.class, new IOException("Remote host terminated the handshake")}));
    }

    @BeforeEach
    public void setup() {
        this.util = new TransportTestUtil();
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @ParameterizedTest(name="{displayName} {index}")
    @MethodSource(value={"transportFactory"})
    public void shouldRejectConnectionAfterHandshake(Class<? extends TransportConnection> c, Exception expected) throws Exception {
        this.client = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Exception exception = (Exception)Assertions.assertThrows(expected.getClass(), () -> this.client.connect(this.server.lookupDefaultConnector()).send(this.util.defaultAcceptedVersions()));
        Assertions.assertEquals((Object)expected.getMessage(), (Object)exception.getMessage());
    }
}

