/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackedOutputArray;
import org.neo4j.bolt.packstream.example.Edges;
import org.neo4j.bolt.packstream.example.Nodes;
import org.neo4j.bolt.packstream.example.Paths;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.PathValue;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class UnsupportedStructTypesV1V2IT
extends AbstractBoltTransportsTest {
    public static final byte DEFAULT_SIGNATURE = 16;
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @AfterEach
    public void cleanup() {
        this.server.shutdownDatabase();
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenNullKeyIsSent(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createMsgWithNullKey()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string.")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenDuplicateKey(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createMsgWithDuplicateKey()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Duplicate map key `key1`.")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenNodeIsSentWithRun(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.testFailureWithV1Value((AnyValue)Nodes.ALICE, "Node");
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenRelationshipIsSentWithRun(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.testFailureWithV1Value((AnyValue)Edges.ALICE_KNOWS_BOB, "Relationship");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenPathIsSentWithRun(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        for (PathValue path : Paths.ALL_PATHS) {
            try {
                this.testFailureWithV1Value((AnyValue)path, "Path");
            }
            finally {
                this.reconnect();
            }
        }
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldTerminateConnectionWhenUnknownMessageIsSent(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createUnknownMsg()}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private void testFailureWithV1Value(AnyValue value, String description) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWithUnknownValue(value)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.TypeError, (String)(description + " values cannot be unpacked with this version of bolt."))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWithUnknownValue(AnyValue value) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.pack(value);
        return out.bytes();
    }

    private byte[] createUnknownMsg() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(0, (byte)16);
        return out.bytes();
    }

    private byte[] createMsgWithNullKey() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithNullKey(packer);
        return out.bytes();
    }

    private byte[] createMsgWithDuplicateKey() throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithDuplicateKey(packer);
        return out.bytes();
    }

    private static void packMapWithNullKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack(ValueUtils.of(null));
        packer.pack(ValueUtils.of(null));
        packer.pack("value1");
    }

    private static void packMapWithDuplicateKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack("value1");
        packer.pack("key1");
        packer.pack("value2");
    }
}

