/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkWithDatabaseId;
import org.neo4j.common.DependencyResolver;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class BoltV4TransportIT {
    private static final String USER_AGENT = "TestClient/4.0";
    @Rule
    public final Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), Neo4jWithSocket.withOptionalBoltEncryption());
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;
    @Parameterized.Parameter
    public Class<? extends TransportConnection> connectionClass;

    @Parameterized.Parameters(name="{0}")
    public static List<Class<? extends TransportConnection>> transports() {
        return Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    }

    @Before
    public void setUp() throws Exception {
        this.address = this.server.lookupDefaultConnector();
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterAutoCommitTransaction() throws Throwable {
        Assume.assumeFalse((boolean)FabricDatabaseManager.fabricByDefault());
        this.negotiateBoltV4();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(responseMessage -> Assertions.assertThat((Map)responseMessage).containsEntry((Object)"bookmark", (Object)expectedBookmark))}));
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterExplicitTransaction() throws Throwable {
        Assume.assumeFalse((boolean)FabricDatabaseManager.fabricByDefault());
        this.negotiateBoltV4();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).doesNotContainEntry((Object)"bookmark", (Object)expectedBookmark))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsEntry((Object)"bookmark", (Object)expectedBookmark))}));
    }

    @Test
    public void shouldStreamWhenStatementIdNotProvided() throws Exception {
        this.negotiateBoltV4();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(30, 40) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 5L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(30L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(31L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(32L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(33L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(34L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(35L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(36L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(37L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(38L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(39L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 10L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(40L))), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"has_more"))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @Test
    public void shouldSendAndReceiveStatementIds() throws Exception {
        this.negotiateBoltV4();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(1, 10) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(1L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(2L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(3L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(11, 20) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)1L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(11L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(12L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(21, 30) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)2L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 4L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(21L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(22L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(23L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(24L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(31, 40) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)3L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 1L, "qid", 3L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(31L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(4L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(5L))), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 9L, "qid", 3L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(32L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(33L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(34L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(35L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(36L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(37L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(38L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(39L))), MessageConditions.msgRecord(StreamConditions.eqRecord(BoltV4TransportIT.longValueCondition(40L))), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"has_more"))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private void negotiateBoltV4() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(4L, 0L, 0L, 0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 4}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private long getLastClosedTransactionId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        TransactionIdStore txIdStore = (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    private NamedDatabaseId getDatabaseId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        Database database = (Database)resolver.resolveDependency(Database.class);
        return database.getNamedDatabaseId();
    }

    private static Condition<AnyValue> longValueCondition(long expected) {
        return new Condition(value -> value.equals((Object)Values.longValue((long)expected)), "equals", new Object[0]);
    }
}

