/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.v4.runtime.FailedState;
import org.neo4j.bolt.v4.runtime.InTransactionState;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;

class InTransactionStateIT
extends BoltStateMachineV4StateTestBase {
    InTransactionStateIT() {
    }

    @Test
    void shouldMoveFromInTxToReadyOnCommit_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)CommitMessage.COMMIT_MESSAGE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromInTxToReadyOnRollback_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)RollbackMessage.ROLLBACK_MESSAGE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldStayInTxOnDiscard_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(InTransactionStateIT.newDiscardMessage(100L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnDiscard_succ_hasMore() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState("Unwind [1, 2, 3] as n return n");
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(InTransactionStateIT.newDiscardMessage(2L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsNoRecord());
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithMetadata((String)"has_more", (AnyValue)BooleanValue.TRUE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("db"));
        machine.process(InTransactionStateIT.newDiscardMessage(2L), (BoltResponseHandler)recorder);
        response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsNoRecord());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithoutMetadata((String)"has_more"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnPull_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(InTransactionStateIT.newPullMessage(100L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnPull_succ_hasMore() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState("Unwind [1, 2, 3] as n return n");
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(InTransactionStateIT.newPullMessage(2L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsRecord((Object[])new Object[]{1L}));
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithMetadata((String)"has_more", (AnyValue)BooleanValue.TRUE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("db"));
        machine.process(InTransactionStateIT.newPullMessage(2L), (BoltResponseHandler)recorder);
        response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsRecord((Object[])new Object[]{3L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnAnotherRun_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("MATCH (n) RETURN n LIMIT 1"), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldMoveFromInTxToFailedOnAnotherRun_fail() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("any string"), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(FailedState.class);
    }

    @Test
    void shouldMoveFromInTxToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"pullAllDiscardAllMessages"})
    void shouldMoveFromInTxStateToFailedStateOnfail(RequestMessage message) throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInTxState();
        BoltResponseHandler handler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onPullRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onDiscardRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        machine.process(message, handler);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(FailedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV4MessagesInTxStreamingState(RequestMessage message) throws Throwable {
        this.shouldThrowExceptionOnIllegalMessagesInTxStreamingState(message);
    }

    private void shouldThrowExceptionOnIllegalMessagesInTxStreamingState(RequestMessage message) throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(InTransactionStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltConditions.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Request.Invalid));
        org.junit.jupiter.api.Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV4Messages() {
        return Stream.of(InTransactionStateIT.newHelloMessage(), new BeginMessage(), ResetMessage.INSTANCE, GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private static Stream<RequestMessage> pullAllDiscardAllMessages() throws BoltIOException {
        return Stream.of(InTransactionStateIT.newPullMessage(100L), InTransactionStateIT.newDiscardMessage(100L));
    }

    private BoltStateMachineV4 getBoltStateMachineInTxState() throws BoltConnectionFatality {
        return this.getBoltStateMachineInTxState("CREATE (n {k:'k'}) RETURN n.k");
    }

    private BoltStateMachineV4 getBoltStateMachineInTxState(String query) throws BoltConnectionFatality {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(InTransactionStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
        machine.process((RequestMessage)new RunMessage(query, EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
        return machine;
    }
}

