/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
@Neo4jWithSocketExtension
class MultipleBoltServerPortsStressTest {
    private static final int DURATION_IN_MINUTES = 1;
    private static final int NUMBER_OF_THREADS = 10;
    private static final String USER_AGENT = "TestClient/4.1";
    private static TransportTestUtil util;
    @Inject
    public Neo4jWithSocket server;

    MultipleBoltServerPortsStressTest() {
    }

    @BeforeEach
    void setUp(TestInfo testInfo) throws IOException {
        this.server.setGraphDatabaseFactory((TestDatabaseManagementServiceBuilder)new SharedAuthManagerDbmsBuilder());
        this.server.setConfigure(settings -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.listen_address, new SocketAddress(0));
            settings.put(GraphDatabaseSettings.routing_enabled, true);
            settings.put(GraphDatabaseSettings.routing_listen_address, new SocketAddress(0));
        });
        this.server.init(testInfo);
        util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
    }

    @AfterEach
    void tearDown() {
        this.server.shutdownDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void splitTrafficBetweenPorts() throws Exception {
        SocketConnection externalConnection = new SocketConnection();
        SocketConnection internalConnection = new SocketConnection();
        try {
            HostnamePort externalAddress = this.server.lookupConnector("bolt");
            HostnamePort internalAddress = this.server.lookupConnector("bolt-internal");
            MultipleBoltServerPortsStressTest.executeStressTest(Executors.newFixedThreadPool(10), externalAddress, internalAddress);
        }
        finally {
            externalConnection.disconnect();
            internalConnection.disconnect();
        }
    }

    private static void executeStressTest(ExecutorService executorPool, HostnamePort external, HostnamePort internal) throws Exception {
        long finishTimeMillis = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        AtomicBoolean failureFlag = new AtomicBoolean(false);
        for (int i = 0; i < 10; ++i) {
            SocketConnection connection = new SocketConnection();
            if (i % 2 == 0) {
                MultipleBoltServerPortsStressTest.initializeConnection(connection, internal);
            } else {
                MultipleBoltServerPortsStressTest.initializeConnection(connection, external);
            }
            executorPool.submit(MultipleBoltServerPortsStressTest.workload(failureFlag, connection, finishTimeMillis));
        }
        executorPool.shutdown();
        executorPool.awaitTermination(1L, TimeUnit.MINUTES);
        Assertions.assertThat((AtomicBoolean)failureFlag).isFalse();
    }

    private static void initializeConnection(SocketConnection connection, HostnamePort address) throws Exception {
        connection.connect(address).send(util.defaultAcceptedVersions());
        Assertions.assertThat((Object)connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 1, 4}));
        connection.send(util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private static Condition<AnyValue> longValueCondition(long expected) {
        return new Condition(value -> value.equals((Object)Values.longValue((long)expected)), "equals", new Object[0]);
    }

    private static Runnable workload(AtomicBoolean failureFlag, SocketConnection connection, long finishTimeMillis) {
        return () -> {
            while (!failureFlag.get() && System.currentTimeMillis() < finishTimeMillis) {
                try {
                    connection.send(util.chunk(new RequestMessage[]{new RunMessage("RETURN 1"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    Assertions.assertThat((Object)connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
                    Assertions.assertThat((Object)connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord(StreamConditions.eqRecord(MultipleBoltServerPortsStressTest.longValueCondition(1L)))}));
                    Assertions.assertThat((Object)connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).printStackTrace();
                    failureFlag.set(true);
                }
            }
        };
    }

    private static class SharedAuthManagerDbmsBuilder
    extends TestDatabaseManagementServiceBuilder {
        private SharedAuthManagerDbmsBuilder() {
        }

        protected Function<GlobalModule, AbstractEditionModule> getEditionFactory(Config config) {
            return globalModule -> new CommunityEditionModule((GlobalModule)globalModule){

                public AuthManager getBoltInClusterAuthManager() {
                    return this.getBoltAuthManager((DependencyResolver)this.globalModule.getGlobalDependencies());
                }
            };
        }
    }
}

