/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class SupportedStructTypesV2IT {
    @Inject
    private Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(Neo4jWithSocket.withOptionalBoltEncryption());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.server.shutdownDatabase();
    }

    public static Stream<Arguments> classProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{SocketConnection.class}), Arguments.of((Object[])new Object[]{WebSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureWebSocketConnection.class}));
    }

    private void initConnection(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.connection = connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldNegotiateProtocolV4(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldNegotiateProtocolV4WhenClientSupportsBothV4AndV3(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.connection.connect(this.address).send(this.util.acceptedVersions(4L, 3L, 0L, 0L)).send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 4}));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendPoint2D(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{39.111748, -76.775635}));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceivePoint2D(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN point({x: 40.7624, y: 73.9738})", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{40.7624, 73.9738}));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceivePoint2D(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{38.8719, 77.0563}));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendDuration(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(DurationValue.duration((long)5L, (long)3L, (long)34L, (long)0L));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveDuration(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN duration({months: 3, days: 100, seconds: 999, nanoseconds: 42})", DurationValue.duration((long)3L, (long)100L, (long)999L, (long)42L));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveDuration(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(DurationValue.duration((long)17L, (long)9L, (long)2L, (long)1000000L));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendDate(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(DateValue.date((int)1991, (int)8, (int)24));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveDate(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN date('2015-02-18')", DateValue.date((int)2015, (int)2, (int)18));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveDate(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(DateValue.date((int)2005, (int)5, (int)22));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendLocalTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(LocalTimeValue.localTime((int)2, (int)35, (int)10, (int)1));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveLocalTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN localtime('11:04:35')", LocalTimeValue.localTime((int)11, (int)4, (int)35, (int)0));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveLocalTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(LocalTimeValue.localTime((int)22, (int)10, (int)10, (int)99));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(TimeValue.time((long)424242L, (ZoneOffset)ZoneOffset.of("+08:30")));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN time('14:30+0100')", TimeValue.time((int)14, (int)30, (int)0, (int)0, (ZoneOffset)ZoneOffset.ofHours(1)));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(TimeValue.time((int)19, (int)22, (int)44, (int)100, (ZoneOffset)ZoneOffset.ofHours(-5)));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendLocalDateTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(LocalDateTimeValue.localDateTime((int)2002, (int)5, (int)22, (int)15, (int)15, (int)25, (int)0));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveLocalDateTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN localdatetime('20150202T19:32:24')", LocalDateTimeValue.localDateTime((int)2015, (int)2, (int)2, (int)19, (int)32, (int)24, (int)0));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveLocalDateTime(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(LocalDateTimeValue.localDateTime((int)1995, (int)12, (int)12, (int)10, (int)30, (int)0, (int)0));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendDateTimeWithTimeZoneName(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(DateTimeValue.datetime((int)1956, (int)9, (int)14, (int)11, (int)20, (int)25, (int)0, (String)"Europe/Stockholm"));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveDateTimeWithTimeZoneName(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN datetime({year:1984, month:10, day:11, hour:21, minute:30, timezone:'Europe/London'})", DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveDateTimeWithTimeZoneName(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendDateTimeWithTimeZoneOffset(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingOfBoltV2Value(DateTimeValue.datetime((long)424242L, (long)0L, (ZoneOffset)ZoneOffset.ofHoursMinutes(-7, -15)));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldReceiveDateTimeWithTimeZoneOffset(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testReceivingOfBoltV2Value("RETURN datetime({year:2022, month:3, day:2, hour:19, minute:10, timezone:'+02:30'})", DateTimeValue.datetime((int)2022, (int)3, (int)2, (int)19, (int)10, (int)0, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(2, 30)));
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldSendAndReceiveDateTimeWithTimeZoneOffset(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testSendingAndReceivingOfBoltV2Value(DateTimeValue.datetime((int)1899, (int)1, (int)1, (int)12, (int)12, (int)32, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(-4, -15)));
    }

    private <T extends AnyValue> void testSendingOfBoltV2Value(T value) throws Exception {
        this.handshakeAndAuth();
        this.connection.send(this.util.defaultRunAutoCommitTx("CREATE (n:Node {value: $value}) RETURN 42", VirtualValues.map((String[])new String[]{"value"}, (AnyValue[])new AnyValue[]{value})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord(StreamConditions.eqRecord(new Condition(v -> v.equals((Object)Values.longValue((long)42L)), "equals condition", new Object[0]))), MessageConditions.msgSuccess()}));
    }

    private <T extends AnyValue> void testReceivingOfBoltV2Value(String query, T expectedValue) throws Exception {
        this.handshakeAndAuth();
        this.connection.send(this.util.defaultRunAutoCommitTx(query));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord(StreamConditions.eqRecord(new Condition(v -> v.equals((Object)expectedValue), "equals condition", new Object[0]))), MessageConditions.msgSuccess()}));
    }

    private <T extends AnyValue> void testSendingAndReceivingOfBoltV2Value(T value) throws Exception {
        this.handshakeAndAuth();
        this.connection.send(this.util.defaultRunAutoCommitTx("RETURN $value", VirtualValues.map((String[])new String[]{"value"}, (AnyValue[])new AnyValue[]{value})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord(StreamConditions.eqRecord(new Condition(v -> v.equals((Object)value), "equals condition", new Object[0]))), MessageConditions.msgSuccess()}));
    }

    private void handshakeAndAuth() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }
}

