/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class ConcurrentAccessIT
extends AbstractBoltTransportsTest {
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunSimpleStatement(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        int numWorkers = 5;
        int numRequests = 1000;
        List<Callable<Void>> workers = this.createWorkers(numWorkers, numRequests);
        ExecutorService exec = Executors.newFixedThreadPool(numWorkers);
        try {
            for (Future<Void> f : exec.invokeAll(workers)) {
                f.get(60L, TimeUnit.SECONDS);
            }
        }
        finally {
            exec.shutdownNow();
            exec.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private List<Callable<Void>> createWorkers(int numWorkers, int numRequests) throws Exception {
        LinkedList<Callable<Void>> workers = new LinkedList<Callable<Void>>();
        for (int i = 0; i < numWorkers; ++i) {
            workers.add(this.newWorker(numRequests));
        }
        return workers;
    }

    private Callable<Void> newWorker(final int iterationsToRun) throws Exception {
        return new Callable<Void>(){
            private final byte[] init;
            private final byte[] createAndRollback;
            private final byte[] matchAll;
            {
                this.init = ConcurrentAccessIT.this.util.defaultAuth();
                this.createAndRollback = ConcurrentAccessIT.this.util.defaultRunExplicitCommitTxAndRollBack("CREATE (n)");
                this.matchAll = ConcurrentAccessIT.this.util.defaultRunAutoCommitTx("MATCH (n) RETURN n");
            }

            @Override
            public Void call() throws Exception {
                TransportConnection client = ConcurrentAccessIT.this.newConnection();
                client.connect(ConcurrentAccessIT.this.server.lookupDefaultConnector()).send(ConcurrentAccessIT.this.util.defaultAcceptedVersions());
                Assertions.assertThat((Object)client).satisfies(ConcurrentAccessIT.this.util.eventuallyReceivesSelectedProtocolVersion());
                this.init(client);
                for (int i = 0; i < iterationsToRun; ++i) {
                    this.createAndRollback(client);
                }
                return null;
            }

            private void init(TransportConnection client) throws Exception {
                client.send(this.init);
                Assertions.assertThat((Object)client).satisfies(ConcurrentAccessIT.this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
            }

            private void createAndRollback(TransportConnection client) throws Exception {
                client.send(this.createAndRollback);
                Assertions.assertThat((Object)client).satisfies(ConcurrentAccessIT.this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"t_first", "qid"}).containsEntry((Object)"fields", Collections.emptyList())), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"t_last", "db"})), MessageConditions.msgSuccess()}));
                client.send(this.matchAll);
                Assertions.assertThat((Object)client).satisfies(ConcurrentAccessIT.this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("n"))), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"t_last", "db"}))}));
            }
        };
    }
}

