/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackedOutputArray;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class UnsupportedStructTypesV2IT {
    @Inject
    private Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(Neo4jWithSocket.withOptionalBoltEncryption());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());
    }

    @AfterEach
    public void cleanup() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public static Stream<Arguments> classProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{SocketConnection.class}), Arguments.of((Object[])new Object[]{WebSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureWebSocketConnection.class}));
    }

    private void initConnection(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.connection = connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldFailWhenPoint2DIsSentWithInvalidCrsId(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.POINT_2D.signature());
            packer.pack((AnyValue)Values.of((Object)5));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
        }), "Unable to construct Point value: `Unknown coordinate reference system code: 5`");
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldFailWhenPoint3DIsSentWithInvalidCrsId(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(4, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)1200));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
            packer.pack((AnyValue)Values.of((Object)5.905));
        }), "Unable to construct Point value: `Unknown coordinate reference system code: 1200`");
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldFailWhenPoint2DDimensionsDoNotMatch(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testDisconnectWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)CoordinateReferenceSystem.Cartesian_3D.getCode()));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
        }), "Unable to construct Point value: `Cannot create point, CRS cartesian-3d expects 3 dimensions, but got coordinates [3.15, 4.012]`");
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldFailWhenPoint3DDimensionsDoNotMatch(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(4, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)CoordinateReferenceSystem.Cartesian.getCode()));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
            packer.pack((AnyValue)Values.of((Object)5.905));
        }), "Unable to construct Point value: `Cannot create point, CRS cartesian expects 2 dimensions, but got coordinates [3.15, 4.012, 5.905]`");
    }

    @ParameterizedTest(name="{displayName} {0}")
    @MethodSource(value={"classProvider"})
    public void shouldFailWhenZonedDateTimeZoneIdIsNotKnown(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.initConnection(connectionClass);
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.DATE_TIME_WITH_ZONE_NAME.signature());
            packer.pack((AnyValue)Values.of((Object)0));
            packer.pack((AnyValue)Values.of((Object)0));
            packer.pack((AnyValue)Values.of((Object)"Europe/Marmaris"));
        }), "Unable to construct ZonedDateTime value: `Unknown time-zone ID: Europe/Marmaris`");
    }

    private void testFailureWithUnpackableValue(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker, String expectedMessage) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWith(valuePacker)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.TypeError, (String)expectedMessage)}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private void testDisconnectWithUnpackableValue(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker, String expectedMessage) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWith(valuePacker)}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWith(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPackV2().newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        valuePacker.accept((Object)packer);
        return out.bytes();
    }
}

