/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.AutoCommitState;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;

class AutoCommitStateIT
extends BoltStateMachineV4StateTestBase {
    AutoCommitStateIT() {
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnPull_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInAutoCommitState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(AutoCommitStateIT.newPullMessage(100L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnPull_succ_hasMore() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInAutoCommitState("Unwind [1, 2, 3] as n return n");
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(AutoCommitStateIT.newPullMessage(2L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsRecord((Object[])new Object[]{1L}));
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeededWithMetadata((String)"has_more", (AnyValue)BooleanValue.TRUE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("db"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasMetadata("bookmark"));
        machine.process(AutoCommitStateIT.newPullMessage(2L), (BoltResponseHandler)recorder);
        response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.containsRecord((Object[])new Object[]{3L}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnDiscardAll_succ() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInAutoCommitState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(AutoCommitStateIT.newDiscardMessage(2L), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("db"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV4 machine = this.getBoltStateMachineInAutoCommitState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV3MessagesInAutoCommitState(RequestMessage message) throws Throwable {
        this.shouldThrowExceptionOnIllegalMessagesInAutoCommitState(message);
    }

    private void shouldThrowExceptionOnIllegalMessagesInAutoCommitState(RequestMessage message) throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(AutoCommitStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(AutoCommitState.class);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltConditions.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Request.Invalid));
        org.junit.jupiter.api.Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV4Messages() {
        return Stream.of(AutoCommitStateIT.newHelloMessage(), new RunMessage("any string"), new BeginMessage(), RollbackMessage.ROLLBACK_MESSAGE, CommitMessage.COMMIT_MESSAGE, ResetMessage.INSTANCE, GoodbyeMessage.GOODBYE_MESSAGE, PullAllMessage.INSTANCE, DiscardAllMessage.INSTANCE);
    }

    private BoltStateMachineV4 getBoltStateMachineInAutoCommitState() throws BoltConnectionFatality {
        return this.getBoltStateMachineInAutoCommitState("CREATE (n {k:'k'}) RETURN n.k");
    }

    private BoltStateMachineV4 getBoltStateMachineInAutoCommitState(String query) throws BoltConnectionFatality {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(AutoCommitStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage(query, EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(AutoCommitState.class);
        return machine;
    }
}

