/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v4.BoltProtocolV4;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@ResourceLock(value="boltStateMachineV4")
public class BoltStateMachineV4StateTestBase {
    protected static final MapValue EMPTY_PARAMS = VirtualValues.EMPTY_MAP;
    protected static final BoltChannel BOLT_CHANNEL = BoltTestUtil.newTestBoltChannel((String)"conn-v4-test-boltchannel-id");
    @RegisterExtension
    static final SessionExtension env = new SessionExtension();

    protected BoltStateMachineV4 newStateMachine() {
        return (BoltStateMachineV4)env.newMachine(BoltProtocolV4.VERSION, BOLT_CHANNEL);
    }

    protected BoltStateMachineV4 newStateMachineAfterAuth() throws BoltConnectionFatality {
        BoltStateMachineV4 machine = (BoltStateMachineV4)env.newMachine(BoltProtocolV4.VERSION, BOLT_CHANNEL);
        machine.process(BoltV4Messages.hello(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }

    protected static RequestMessage newHelloMessage() {
        return BoltV4Messages.hello();
    }

    protected static RequestMessage newPullMessage(long size) throws BoltIOException {
        return BoltV4Messages.pull((long)size);
    }

    protected static RequestMessage newDiscardMessage(long size) throws BoltIOException {
        return BoltV4Messages.discard((long)size);
    }
}

