/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class RoutingConnectorCertificatesIT {
    private static Path externalKeyFile;
    private static Path externalCertFile;
    private static Path internalKeyFile;
    private static Path internalCertFile;
    private static SelfSignedCertificateFactory certFactory;
    private static TransportTestUtil util;
    @Inject
    public Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        this.server.setConfigure(RoutingConnectorCertificatesIT.getSettingsFunction());
        this.server.init(testInfo);
    }

    private static Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            SslPolicyConfig externalPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
            settings.put(externalPolicy.enabled, true);
            settings.put(externalPolicy.public_certificate, externalCertFile.toAbsolutePath());
            settings.put(externalPolicy.private_key, externalKeyFile.toAbsolutePath());
            SslPolicyConfig internalPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER);
            settings.put(internalPolicy.enabled, true);
            settings.put(internalPolicy.client_auth, ClientAuth.NONE);
            settings.put(internalPolicy.public_certificate, internalCertFile.toAbsolutePath());
            settings.put(internalPolicy.private_key, internalKeyFile.toAbsolutePath());
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
            settings.put(GraphDatabaseSettings.routing_enabled, true);
            settings.put(GraphDatabaseSettings.routing_listen_address, new SocketAddress("localhost", 0));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseConfiguredCertificate() throws Exception {
        SecureSocketConnection externalConnection = new SecureSocketConnection();
        SecureSocketConnection internalConnection = new SecureSocketConnection();
        try {
            externalConnection.connect(this.server.lookupConnector("bolt")).send(util.defaultAcceptedVersions());
            internalConnection.connect(this.server.lookupConnector("bolt-internal")).send(util.defaultAcceptedVersions());
            Set externalCertificatesSeen = externalConnection.getServerCertificatesSeen();
            Set internalCertificatesSeen = internalConnection.getServerCertificatesSeen();
            Assertions.assertThat((Iterable)externalCertificatesSeen).isNotEqualTo((Object)internalCertificatesSeen);
            Assertions.assertThat((Iterable)externalCertificatesSeen).containsExactly((Object[])new X509Certificate[]{this.loadCertificateFromDisk(externalCertFile)});
            Assertions.assertThat((Iterable)internalCertificatesSeen).containsExactly((Object[])new X509Certificate[]{this.loadCertificateFromDisk(internalCertFile)});
        }
        finally {
            externalConnection.disconnect();
            internalConnection.disconnect();
        }
    }

    private X509Certificate loadCertificateFromDisk(Path certFile) throws CertificateException, IOException {
        X509Certificate[] certificates = PkiUtils.loadCertificates((Path)certFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        return certificates[0];
    }

    @BeforeAll
    public static void setUp() throws IOException, GeneralSecurityException, OperatorCreationException {
        certFactory = new SelfSignedCertificateFactory();
        externalKeyFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        externalCertFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        Files.delete(externalKeyFile);
        Files.delete(externalCertFile);
        certFactory.createSelfSignedCertificate(externalCertFile, externalKeyFile, "my.domain");
        internalKeyFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        internalCertFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        Files.delete(internalKeyFile);
        Files.delete(internalCertFile);
        certFactory.createSelfSignedCertificate(internalCertFile, internalKeyFile, "my.domain");
        util = new TransportTestUtil();
    }
}

