/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v41.runtime;

import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.bolt.v41.BoltProtocolV41;
import org.neo4j.bolt.v41.BoltStateMachineV41;
import org.neo4j.bolt.v41.messaging.BoltV41Messages;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@ResourceLock(value="boltStateMachineV41")
public class BoltStateMachineV41StateTestBase {
    protected static final MapValue EMPTY_PARAMS = VirtualValues.EMPTY_MAP;
    protected static final BoltChannel BOLT_CHANNEL = BoltTestUtil.newTestBoltChannel((String)"conn-v41-test-boltchannel-id");
    protected static final MemoryTracker MEMORY_TRACKER = EmptyMemoryTracker.INSTANCE;
    @RegisterExtension
    static final SessionExtension env = new SessionExtension();

    protected BoltStateMachineV41 newStateMachine() {
        return (BoltStateMachineV41)env.newMachine(BoltProtocolV41.VERSION, BOLT_CHANNEL, MEMORY_TRACKER);
    }

    protected BoltStateMachineV41 newStateMachineAfterAuth() throws BoltConnectionFatality {
        BoltStateMachineV41 machine = (BoltStateMachineV41)env.newMachine(BoltProtocolV41.VERSION, BOLT_CHANNEL, MEMORY_TRACKER);
        machine.process(BoltV4Messages.hello(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }

    protected static RequestMessage newHelloMessage() {
        return BoltV41Messages.hello();
    }

    protected static RequestMessage newPullMessage(long size) throws BoltIOException {
        return BoltV41Messages.pull((long)size);
    }

    protected static RequestMessage newDiscardMessage(long size) throws BoltIOException {
        return BoltV41Messages.discard((long)size);
    }
}

