/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.response.FailureMessage;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class AuthenticationIT
extends AbstractBoltTransportsTest {
    protected final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;

    protected TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        return new TestDatabaseManagementServiceBuilder().setUserLogProvider((LogProvider)this.logProvider);
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setGraphDatabaseFactory(this.getTestGraphDatabaseFactory());
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @Override
    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            super.getSettingsFunction().accept((Map<Setting<?>, Object>)settings);
            settings.put(GraphDatabaseSettings.auth_enabled, true);
        };
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRespondWithCredentialsExpiredOnFirstUse(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"credentials_expired", (Object)true)).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
        this.verifyConnectionOpen();
    }

    private void verifyConnectionOpen() throws IOException {
        this.connection.send(this.util.defaultReset());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfWrongCredentials(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
        Assert.assertEventually(() -> "Matching log call not found in\n" + this.logProvider.serialize(), this::authFailureLoggedToUserLog, (Condition)Conditions.TRUE, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    private boolean authFailureLoggedToUserLog() {
        try {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(DefaultBoltConnection.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"The client is unauthorized due to authentication failure."});
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfWrongCredentialsFollowingSuccessfulLogin(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "secret"), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfMalformedAuthTokenWrongType(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", Collections.singletonList("neo4j"), "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfMalformedAuthTokenMissingKey(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "this-should-have-been-credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `credentials`")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfMalformedAuthTokenMissingScheme(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `scheme`")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailIfMalformedAuthTokenUnknownScheme(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "unknown"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, scheme 'unknown' is not supported.")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailDifferentlyIfTooManyFailedAuthAttempts(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        long timeout = System.currentTimeMillis() + 60000L;
        FailureMessage failureMessage = null;
        block5: while (failureMessage == null) {
            int i;
            if (System.currentTimeMillis() > timeout) {
                org.junit.jupiter.api.Assertions.fail((String)"Timed out waiting for the authentication failure to occur.");
            }
            ExecutorService executor = Executors.newFixedThreadPool(10);
            ArrayList<CompletableFuture<FailureMessage>> futures = new ArrayList<CompletableFuture<FailureMessage>>();
            for (i = 0; i < 10; ++i) {
                futures.add(CompletableFuture.supplyAsync(this::collectAuthFailureOnFailedAuth, executor));
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                for (i = 0; i < futures.size(); ++i) {
                    FailureMessage recordedMessage = (FailureMessage)((CompletableFuture)futures.get(i)).get();
                    if (recordedMessage == null) continue;
                    failureMessage = recordedMessage;
                    continue block5;
                }
            }
            catch (TimeoutException timeoutException) {}
            continue;
            finally {
                executor.shutdown();
            }
        }
        Assertions.assertThat((Object)failureMessage.status()).isEqualTo((Object)Status.Security.AuthenticationRateLimit);
        Assertions.assertThat((String)failureMessage.message()).contains(new CharSequence[]{"The client has provided incorrect authentication details too many times in a row."});
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldBeAbleToChangePasswordUsingSystemCommand(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"credentials_expired", (Object)true)).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "secret"), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenReusingTheSamePassword(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"credentials_expired", (Object)true)).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "neo4j"), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.ArgumentError, (String)"Old password and new password cannot be the same.")}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "abc"), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgIgnored(), MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailWhenSubmittingEmptyPassword(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"credentials_expired", (Object)true)).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", ""), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.ArgumentError, (String)"A password cannot be empty.")}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", this.singletonMap("password", "abc"), "system"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgIgnored(), MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNotBeAbleToReadWhenPasswordChangeRequired(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"})));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"credentials_expired", (Object)true)).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
        this.connection.send(this.util.defaultRunAutoCommitTx("MATCH (n) RETURN n"));
        Consumer expectedFailureMessage = MessageConditions.msgFailure((Status)Status.Security.CredentialsExpired, (String)"The credentials you provided were valid, but must be changed before you can use this instance.");
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesWithOptionalPrecedingMessages(new Pair[]{Pair.of((Object)MessageConditions.msgSuccess(), (Object)TransportTestUtil.ResponseMatcherOptionality.OPTIONAL), Pair.of((Object)expectedFailureMessage, (Object)TransportTestUtil.ResponseMatcherOptionality.REQUIRED)}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }

    private FailureMessage collectAuthFailureOnFailedAuth() {
        FailureMsgMatcher failureRecorder = new FailureMsgMatcher();
        TransportConnection connection = null;
        try {
            connection = this.newConnection();
            connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth(MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN", "scheme", "basic"})));
            Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
            Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{failureRecorder}));
            Assertions.assertThat((Object)connection).satisfies(TransportTestUtil.eventuallyDisconnects());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return failureRecorder.specialMessage;
    }

    static class FailureMsgMatcher
    implements Consumer<ResponseMessage> {
        FailureMessage specialMessage;

        FailureMsgMatcher() {
        }

        @Override
        public void accept(ResponseMessage responseMessage) {
            Assertions.assertThat((Object)responseMessage).isInstanceOf(FailureMessage.class);
            FailureMessage msg = (FailureMessage)responseMessage;
            if (!msg.status().equals(Status.Security.Unauthorized) || !msg.message().contains("The client is unauthorized due to authentication failure.")) {
                this.specialMessage = msg;
            }
        }
    }
}

