/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackedOutputArray;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.BoltV3TransportBase;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarkWithPrefix;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class BoltV3TransportIT
extends BoltV3TransportBase {
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNegotiateProtocolV3(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 0L, 0L, 0L)).send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TestClient/3.0"}))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"server", "connection_id"}))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNegotiateProtocolV3WhenClientSupportsBothV1V2AndV3(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 2L, 1L, 0L)).send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TestClient/3.0"}))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunSimpleStatement(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L), this.longEquals(1L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(2L), this.longEquals(4L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(3L), this.longEquals(9L)})), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"bookmark", "t_last"}).containsEntry((Object)"type", (Object)"r"))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRespondWithMetadataToDiscardAll(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), DiscardAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKeys((Object[])new String[]{"t_last", "bookmark"}).containsEntry((Object)"type", (Object)"r"))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunSimpleStatementInTx(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE, CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L), this.longEquals(1L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(2L), this.longEquals(4L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(3L), this.longEquals(9L)})), MessageConditions.msgSuccess(message -> ((MapAssert)((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"bookmark")).containsEntry((Object)"type", (Object)"r")), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsKey((Object)"bookmark"))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldAllowRollbackSimpleStatementInTx(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE, RollbackMessage.ROLLBACK_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L), this.longEquals(1L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(2L), this.longEquals(4L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(3L), this.longEquals(9L)})), MessageConditions.msgSuccess(message -> ((MapAssert)((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"bookmark")).containsEntry((Object)"type", (Object)"r")), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldBeAbleToRunQueryAfterReset(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("QINVALID"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("line 1, column 1", new Object[0])), MessageConditions.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L)})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunProcedure(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n:Test {age: 2}) RETURN n.age AS age"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("age"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(2L)})), MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CALL db.labels() YIELD label"), PullAllMessage.INSTANCE}));
        Condition stringEquality = new Condition(value -> value.equals((Object)Values.stringValue((String)"Test")), "String equals", new Object[0]);
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("label"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{stringEquality})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleDeletedNodes(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n:Test) DELETE n RETURN n"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("n")))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleDeletedRelationships(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("r")))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 11, 177, 113, 145, 181, 82, 0, 0, 1, 129, 84, 160, 0, 0)));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNotLeakStatsToNextStatement(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n)"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L)})), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"))}));
    }

    private byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailNicelyOnNullKeysInMap(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        HashMap params = new HashMap();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("RETURN $p", ValueUtils.asMapValue(params)), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), MessageConditions.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L)})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailNicelyWhenDroppingUnknownIndex(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("DROP INDEX on :Movie12345(id)"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Schema.IndexDropFailed, (String)"Unable to drop index on (:Movie12345 {id}). There is no such index."), MessageConditions.msgIgnored()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSetTxMetadata(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        Map txMetadata = MapUtil.map((Object[])new Object[]{"who-is-your-boss", "Molly-mostly-white"});
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(meta, List.of(), null, AccessMode.WRITE, txMetadata), new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{this.longEquals(1L)})), MessageConditions.msgSuccess()}));
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)this.server.graphDatabaseService();
        Set txHandles = ((KernelTransactions)gdb.getDependencyResolver().resolveDependency(KernelTransactions.class)).activeTransactions();
        Assertions.assertThat((int)txHandles.size()).isEqualTo(1);
        for (KernelTransactionHandle txHandle : txHandles) {
            Assertions.assertThat((Map)txHandle.getMetaData()).isEqualTo((Object)txMetadata);
        }
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForBeginWithInvalidBookmark(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String bookmarkString = "Not a good bookmark for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"bookmarks", Collections.singletonList(bookmarkString)});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Transaction.InvalidBookmark, (String)bookmarkString)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForBeginWithInvalidTransactionTimeout(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String txTimeout = "Tx timeout can't be a string for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_timeout", txTimeout});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)txTimeout)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForBeginWithInvalidTransactionMetadata(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String txMetadata = "Tx metadata can't be a string for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)txMetadata)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForRunWithInvalidBookmark(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String bookmarkString = "Not a good bookmark for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"bookmarks", Collections.singletonList(bookmarkString)});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Transaction.InvalidBookmark, (String)bookmarkString)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForRunWithInvalidTransactionTimeout(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String txTimeout = "Tx timeout can't be a string for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_timeout", txTimeout});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)txTimeout)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendFailureMessageForRunWithInvalidTransactionMetadata(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        String txMetadata = "Tx metadata can't be a string for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)txMetadata)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnUpdatedBookmarkAfterAutoCommitTransaction(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV3();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithPrefix(lastClosedTransactionId + 1L).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), PullAllMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsEntry((Object)"bookmark", (Object)expectedBookmark))}));
    }

    private Condition<AnyValue> longEquals(long expected) {
        return new Condition(value -> value.equals((Object)Values.longValue((long)expected)), "long equals", new Object[0]);
    }

    private byte[] beginMessage(Map<String, Object> metadata) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.util.getNeo4jPack().newPacker((PackOutput)out);
        packer.packStructHeader(1, (byte)17);
        packer.pack((AnyValue)ValueUtils.asMapValue(metadata));
        return out.bytes();
    }

    private byte[] runMessage(Map<String, Object> metadata) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.util.getNeo4jPack().newPacker((PackOutput)out);
        packer.packStructHeader(3, (byte)16);
        packer.pack("RETURN 1");
        packer.pack((AnyValue)VirtualValues.EMPTY_MAP);
        packer.pack((AnyValue)ValueUtils.asMapValue(metadata));
        return out.bytes();
    }

    private long getLastClosedTransactionId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        TransactionIdStore txIdStore = (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    @Override
    protected boolean fabricEnabled() {
        return false;
    }
}

