/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class BoltKeepAliveSchedulingIT {
    @Inject
    private Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            settings.put(GraphDatabaseSettings.auth_enabled, false);
            settings.put(BoltConnectorInternalSettings.connection_keep_alive, Duration.ofMillis(20L));
            settings.put(BoltConnectorInternalSettings.connection_keep_alive_streaming_scheduling_interval, Duration.ofMillis(10L));
        };
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        BoltKeepAliveSchedulingIT.installSleepProcedure(this.server.graphDatabaseService());
        this.address = this.server.lookupDefaultConnector();
        this.connection = new SocketConnection();
        this.util = new TransportTestUtil();
    }

    @Test
    public void shouldSendNoOpForLongRunningTx() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        AtomicInteger noOpCounter = new AtomicInteger(0);
        LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceivesSelectedProtocolVersion());
        LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(true, noOpCounter::incrementAndGet, new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTxWithoutResult("CALL boltissue.sleep()"));
        LogAssertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(true, noOpCounter::incrementAndGet, new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
        LogAssertions.assertThat((int)noOpCounter.get()).isGreaterThan(1);
    }

    private static void installSleepProcedure(GraphDatabaseService db) throws ProcedureException {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        ((GlobalProcedures)dbApi.getDependencyResolver().resolveDependency(GlobalProcedures.class)).register((CallableProcedure)new CallableProcedure.BasicProcedure(ProcedureSignature.procedureSignature((String[])new String[]{"boltissue", "sleep"}).out(ProcedureSignature.VOID).build()){

            public RawIterator<AnyValue[], ProcedureException> apply(Context context, AnyValue[] objects, ResourceTracker resourceTracker) throws ProcedureException {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Interrupted", new Object[0]);
                }
                return RawIterator.empty();
            }
        });
    }
}

