/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.Assertions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.jcajce.JcaBasicOCSPRespBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.CertConfiguredSecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.CommonConnectorConfig;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.ssl.CertificateChainFactory;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
class OcspStaplingIT {
    private static Path endUserKeyFile;
    private static Path endUserCertFile;
    private static Path intKeyFile;
    private static Path rootCertFile;
    private static Path rootKeyFile;
    private static TransportTestUtil util;
    @Inject
    private Neo4jWithSocket server;

    OcspStaplingIT() {
    }

    @BeforeEach
    void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> {
            SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
            settings.put(policy.enabled, true);
            settings.put(policy.public_certificate, endUserCertFile.toAbsolutePath());
            settings.put(policy.private_key, endUserKeyFile.toAbsolutePath());
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(CommonConnectorConfig.ocsp_stapling_enabled, true);
            settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        });
        this.server.init(testInfo);
    }

    @Test
    void shouldReturnCertificatesWithStapledOcspResponses() throws Exception {
        X509Certificate rootCertificate = OcspStaplingIT.loadCertificateFromDisk();
        CertConfiguredSecureSocketConnection connection = new CertConfiguredSecureSocketConnection(rootCertificate);
        connection.connect(this.server.lookupConnector("bolt")).send(util.defaultAcceptedVersions());
        Set certificatesSeen = connection.getServerCertificatesSeen();
        List certificateSerialNumbersSeen = certificatesSeen.stream().map(X509Certificate::getSerialNumber).collect(Collectors.toList());
        Assertions.assertThat((int)certificatesSeen.size()).isEqualTo(3);
        Set ocspResponsesSeen = connection.getSeenOcspResponses();
        Assertions.assertThat((int)ocspResponsesSeen.size()).isEqualTo(2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ocspResponsesSeen.stream().allMatch(basicOCSPResp -> Objects.isNull(basicOCSPResp.getResponses()[0].getCertStatus())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ocspResponsesSeen.stream().allMatch(basicOCSPResp -> certificateSerialNumbersSeen.contains(basicOCSPResp.getResponses()[0].getCertID().getSerialNumber())));
    }

    private static X509Certificate loadCertificateFromDisk() throws CertificateException, IOException {
        X509Certificate[] certificates = PkiUtils.loadCertificates((Path)rootCertFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        return certificates[0];
    }

    @BeforeAll
    static void setup() throws Exception {
        int jettyServerPortNo = OcspStaplingIT.startOcspMock();
        endUserKeyFile = Files.createTempFile("end_key", "pem", new FileAttribute[0]);
        endUserCertFile = Files.createTempFile("end_key", "pem", new FileAttribute[0]);
        intKeyFile = Files.createTempFile("int_key", "pem", new FileAttribute[0]);
        Path intCertFile = Files.createTempFile("int_key", "pem", new FileAttribute[0]);
        rootCertFile = Files.createTempFile("root_key", "pem", new FileAttribute[0]);
        rootKeyFile = Files.createTempFile("root_key", "pem", new FileAttribute[0]);
        Files.delete(endUserKeyFile);
        Files.delete(endUserCertFile);
        Files.delete(rootKeyFile);
        Files.delete(rootCertFile);
        Files.delete(intKeyFile);
        Files.delete(intCertFile);
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        CertificateChainFactory.createCertificateChain((Path)endUserCertFile, (Path)endUserKeyFile, (Path)intCertFile, (Path)intKeyFile, (Path)rootCertFile, (Path)rootKeyFile, (int)jettyServerPortNo, (BouncyCastleProvider)bouncyCastleProvider);
        util = new TransportTestUtil();
    }

    private static int startOcspMock() throws Exception {
        Server jettyServer = new Server(0);
        ServletHandler handler = new ServletHandler();
        jettyServer.setHandler((Handler)handler);
        jettyServer.setDumpBeforeStop(true);
        handler.addServletWithMapping(EndUserOcspResponderServlet.class, "/endUserCA/*");
        handler.addServletWithMapping(IntOcspResponderServlet.class, "/intCA/*");
        jettyServer.start();
        return jettyServer.getURI().getPort();
    }

    public static class IntOcspResponderServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        private void serveResponse(HttpServletResponse httpResponse) {
            try {
                X509Certificate[] issueCert = PkiUtils.loadCertificates((Path)endUserCertFile);
                PrivateKey privateKey = PkiUtils.loadPrivateKey((Path)rootKeyFile, null);
                X509CertificateHolder[] certChain = new X509CertificateHolder[]{new X509CertificateHolder(issueCert[0].getEncoded()), new X509CertificateHolder(issueCert[1].getEncoded()), new X509CertificateHolder(issueCert[2].getEncoded())};
                DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
                JcaBasicOCSPRespBuilder respGen = new JcaBasicOCSPRespBuilder(issueCert[1].getPublicKey(), digCalcProv.get(RespID.HASH_SHA1));
                CertificateID certificateID = new CertificateID(digCalcProv.get(RespID.HASH_SHA1), certChain[2], issueCert[1].getSerialNumber());
                respGen.addResponse(certificateID, CertificateStatus.GOOD);
                BasicOCSPResp resp = respGen.build(new JcaContentSignerBuilder("SHA1withRSA").build(privateKey), certChain, new Date());
                OCSPRespBuilder rGen = new OCSPRespBuilder();
                OCSPResp ocspResp = rGen.build(0, (Object)resp);
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write(ocspResp.getEncoded());
            }
            catch (Exception e) {
                Assertions.fail((String)"Error whilst responding to intermediate certificates OCSP request");
            }
        }
    }

    public static class EndUserOcspResponderServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        private void serveResponse(HttpServletResponse httpResponse) {
            try {
                X509Certificate[] issueCert = PkiUtils.loadCertificates((Path)endUserCertFile);
                PrivateKey privateKey = PkiUtils.loadPrivateKey((Path)intKeyFile, null);
                X509CertificateHolder[] certChain = new X509CertificateHolder[]{new X509CertificateHolder(issueCert[0].getEncoded()), new X509CertificateHolder(issueCert[1].getEncoded())};
                DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
                JcaBasicOCSPRespBuilder respGen = new JcaBasicOCSPRespBuilder(issueCert[0].getPublicKey(), digCalcProv.get(RespID.HASH_SHA1));
                CertificateID certificateID = new CertificateID(digCalcProv.get(RespID.HASH_SHA1), certChain[1], issueCert[0].getSerialNumber());
                respGen.addResponse(certificateID, CertificateStatus.GOOD);
                BasicOCSPResp resp = respGen.build(new JcaContentSignerBuilder("SHA1withRSA").build(privateKey), certChain, new Date());
                OCSPRespBuilder rGen = new OCSPRespBuilder();
                OCSPResp ocspResp = rGen.build(0, (Object)resp);
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write(ocspResp.getEncoded());
            }
            catch (Exception e) {
                Assertions.fail((String)"Error whilst responding to intermediate certificates OCSP request");
            }
        }
    }
}

