/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class RequiredTransportEncryptionIT {
    private HostnamePort address;
    private TransportConnection client;
    private TransportTestUtil util;
    @Inject
    private Neo4jWithSocket server;

    public static Stream<Arguments> factoryProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{SocketConnection.class}), Arguments.of((Object[])new Object[]{WebSocketConnection.class}));
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.REQUIRED));
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil();
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @ParameterizedTest(name="{displayName} {index}")
    @MethodSource(value={"factoryProvider"})
    public void shouldCloseUnencryptedConnectionOnHandshakeWhenEncryptionIsRequired(Class<? extends TransportConnection> c) throws Exception {
        this.client = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        RequiredTransportEncryptionIT requiredTransportEncryptionIT = this;
        this.client.connect(this.address).send(requiredTransportEncryptionIT.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.client).satisfies(TransportTestUtil.eventuallyDisconnects());
    }
}

