/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TestNotification;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class TransportSessionIT
extends AbstractBoltTransportsTest {
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNegotiateProtocolVersion(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnNilOnNoApplicableVersion(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        this.connection.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1337L, (long)0L, (long)0L, (long)0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 0}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunSimpleStatement(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(1L), TransportSessionIT.longEquals(1L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(2L), TransportSessionIT.longEquals(4L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(3L), TransportSessionIT.longEquals(9L)})), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"))}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRespondWithMetadataToDiscardAll(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTxWithoutResult("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Arrays.asList("a", "a_squared"))), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"))}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldBeAbleToRunQueryAfterAckFailure(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("QINVALID"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("line 1, column 1", new Object[0])), MessageConditions.msgIgnored()}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(1L)})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldRunProcedure(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n:Test {age: 2}) RETURN n.age AS age"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("age"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(2L)})), MessageConditions.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("CALL db.labels() YIELD label"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("label"))), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{new Condition(v -> v.equals((Object)Values.stringValue((String)"Test")), "Test value", new Object[0])})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleDeletedNodes(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n:Test) DELETE n RETURN n"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("n")))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])TransportSessionIT.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleDeletedRelationships(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_first")).containsEntry((Object)"fields", Collections.singletonList("r")))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])TransportSessionIT.bytes(0, 10, 177, 113, 145, 181, 82, 0, -1, -1, 128, 160, 0, 0)));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNotLeakStatsToNextStatement(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("CREATE (n)"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgSuccess()}));
        this.connection.send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(1L)})), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"))}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendNotifications(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.hasNotification((Notification)new TestNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, new InputPosition(17, 1, 18)))}));
    }

    private static byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailNicelyOnNullKeysInMap(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        HashMap params = new HashMap();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("RETURN {p}", ValueUtils.asMapValue(params)));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), MessageConditions.msgIgnored()}));
        this.connection.send(this.util.defaultReset()).send(this.util.defaultRunAutoCommitTx("RETURN 1"));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{TransportSessionIT.longEquals(1L)})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFailNicelyWhenDroppingUnknownIndex(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportSessionIT transportSessionIT = this;
        this.connection.connect(this.address).send(transportSessionIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.defaultRunAutoCommitTx("DROP INDEX on :Movie12345(id)"));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgFailure((Status)Status.Schema.IndexDropFailed, (String)"Unable to drop index on (:Movie12345 {id}). There is no such index."), MessageConditions.msgIgnored()}));
    }

    private static Condition<AnyValue> longEquals(long expected) {
        return new Condition(value -> value.equals((Object)Values.longValue((long)expected)), "long equals", new Object[0]);
    }
}

