/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackedOutputArray;
import org.neo4j.bolt.packstream.example.Nodes;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.storable.TextArray;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@ExtendWith(value={OtherThreadExtension.class})
public class TransportUnauthenticatedConnectionErrorIT
extends AbstractBoltTransportsTest {
    @Inject
    private Neo4jWithSocket server;
    @Inject
    private OtherThread otherThread;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @Override
    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout, Duration.ofSeconds(5L));
            settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes, ByteUnit.kibiBytes((long)1L));
        };
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldFinishHelloMessage(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        this.connection.connect(this.address).send(transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.disconnect();
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldTimeoutTooSlowConnection(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        byte[] handshakeBytes = transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions();
        TransportConnection conn = this.connection.connect(this.address);
        this.otherThread.execute(() -> {
            byte[] buffer = new byte[1];
            byte[] byArray = handshakeBytes;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte aByte;
                buffer[0] = aByte = byArray[i];
                conn.send(buffer);
                Thread.sleep(500L);
            }
            return null;
        });
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldTimeoutToHandshakeForHalfHandshake(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        ByteBuffer bb = ByteBuffers.allocate((int)4, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        bb.putInt(1616949271);
        this.connection.connect(this.address).send(bb.array());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldTimeoutToAuthForHalfHelloMessage(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        byte[] helloMessage = this.util.defaultAuth();
        ByteBuffer buffer = ByteBuffer.wrap(helloMessage, 0, helloMessage.length / 2);
        byte[] halfMessage = new byte[buffer.limit()];
        buffer.get(halfMessage);
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        this.connection.connect(this.address).send(transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions()).send(halfMessage);
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldCloseConnectionDueToTooBigHelloMessage(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        HashMap<CallSite, Integer> authMeta = new HashMap<CallSite, Integer>();
        for (int i = 0; i < 100; ++i) {
            authMeta.put((CallSite)((Object)("index-" + i)), i);
        }
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        this.connection.connect(this.address).send(transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions()).send(this.util.defaultAuth(authMeta));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldCloseConnectionDueToTooBigDeclaredMapInHelloMessage(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        this.connection.connect(this.address).send(transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions()).send(TransportTestUtil.chunk((int)64, (byte[][])new byte[][]{TransportUnauthenticatedConnectionErrorIT.createHelloWithOversizeDeclaredMap(neo4jPack)}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Collection size exceeds message capacity")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldCloseConnectionDueToTooBigDeclaredListInHelloMessage(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        TransportUnauthenticatedConnectionErrorIT transportUnauthenticatedConnectionErrorIT = this;
        this.connection.connect(this.address).send(transportUnauthenticatedConnectionErrorIT.util.defaultAcceptedVersions()).send(TransportTestUtil.chunk((int)64, (byte[][])new byte[][]{TransportUnauthenticatedConnectionErrorIT.createHelloWithOversizeDeclaredList(neo4jPack)}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Request.Invalid, (String)"Collection size exceeds message capacity")}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }

    private static byte[] createHelloWithOversizeDeclaredMap(Neo4jPack neo4jPack) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)1);
        packer.packMapHeader(Integer.MAX_VALUE);
        packer.pack("x");
        packer.pack("Boom!");
        return out.bytes();
    }

    static byte[] createHelloWithOversizeDeclaredList(Neo4jPack neo4jPack) throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)output);
        packer.packStructHeader(2, (byte)1);
        packer.packMapHeader(1);
        packer.pack("x");
        packer.packListHeader(Integer.MAX_VALUE);
        TextArray labels = Nodes.ALICE.labels();
        for (int i = 0; i < labels.length(); ++i) {
            String labelName = labels.stringValue(i);
            packer.pack(labelName);
        }
        return output.bytes();
    }
}

