/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractBoltStateMachine;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.transaction.StatementProcessorTxManager;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class BoltConnectionIT
extends BoltStateMachineV4StateTestBase {
    private static final String[] IRIS_CLASS_NAMES = new String[]{"Iris-setosa", "Iris-versicolor", "Iris-virginica"};
    private static final String IRIS_DATA = "sepal_length,sepal_width,petal_length,petal_width,class_name\n5.1,3.5,1.4,0.2,Iris-setosa\n4.9,3.0,1.4,0.2,Iris-setosa\n4.7,3.2,1.3,0.2,Iris-setosa\n4.6,3.1,1.5,0.2,Iris-setosa\n5.0,3.6,1.4,0.2,Iris-setosa\n5.4,3.9,1.7,0.4,Iris-setosa\n4.6,3.4,1.4,0.3,Iris-setosa\n5.0,3.4,1.5,0.2,Iris-setosa\n4.4,2.9,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.1,Iris-setosa\n5.4,3.7,1.5,0.2,Iris-setosa\n4.8,3.4,1.6,0.2,Iris-setosa\n4.8,3.0,1.4,0.1,Iris-setosa\n4.3,3.0,1.1,0.1,Iris-setosa\n5.8,4.0,1.2,0.2,Iris-setosa\n5.7,4.4,1.5,0.4,Iris-setosa\n5.4,3.9,1.3,0.4,Iris-setosa\n5.1,3.5,1.4,0.3,Iris-setosa\n5.7,3.8,1.7,0.3,Iris-setosa\n5.1,3.8,1.5,0.3,Iris-setosa\n5.4,3.4,1.7,0.2,Iris-setosa\n5.1,3.7,1.5,0.4,Iris-setosa\n4.6,3.6,1.0,0.2,Iris-setosa\n5.1,3.3,1.7,0.5,Iris-setosa\n4.8,3.4,1.9,0.2,Iris-setosa\n5.0,3.0,1.6,0.2,Iris-setosa\n5.0,3.4,1.6,0.4,Iris-setosa\n5.2,3.5,1.5,0.2,Iris-setosa\n5.2,3.4,1.4,0.2,Iris-setosa\n4.7,3.2,1.6,0.2,Iris-setosa\n4.8,3.1,1.6,0.2,Iris-setosa\n5.4,3.4,1.5,0.4,Iris-setosa\n5.2,4.1,1.5,0.1,Iris-setosa\n5.5,4.2,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.2,Iris-setosa\n5.0,3.2,1.2,0.2,Iris-setosa\n5.5,3.5,1.3,0.2,Iris-setosa\n4.9,3.6,1.4,0.1,Iris-setosa\n4.4,3.0,1.3,0.2,Iris-setosa\n5.1,3.4,1.5,0.2,Iris-setosa\n5.0,3.5,1.3,0.3,Iris-setosa\n4.5,2.3,1.3,0.3,Iris-setosa\n4.4,3.2,1.3,0.2,Iris-setosa\n5.0,3.5,1.6,0.6,Iris-setosa\n5.1,3.8,1.9,0.4,Iris-setosa\n4.8,3.0,1.4,0.3,Iris-setosa\n5.1,3.8,1.6,0.2,Iris-setosa\n4.6,3.2,1.4,0.2,Iris-setosa\n5.3,3.7,1.5,0.2,Iris-setosa\n5.0,3.3,1.4,0.2,Iris-setosa\n7.0,3.2,4.7,1.4,Iris-versicolor\n6.4,3.2,4.5,1.5,Iris-versicolor\n6.9,3.1,4.9,1.5,Iris-versicolor\n5.5,2.3,4.0,1.3,Iris-versicolor\n6.5,2.8,4.6,1.5,Iris-versicolor\n5.7,2.8,4.5,1.3,Iris-versicolor\n6.3,3.3,4.7,1.6,Iris-versicolor\n4.9,2.4,3.3,1.0,Iris-versicolor\n6.6,2.9,4.6,1.3,Iris-versicolor\n5.2,2.7,3.9,1.4,Iris-versicolor\n5.0,2.0,3.5,1.0,Iris-versicolor\n5.9,3.0,4.2,1.5,Iris-versicolor\n6.0,2.2,4.0,1.0,Iris-versicolor\n6.1,2.9,4.7,1.4,Iris-versicolor\n5.6,2.9,3.6,1.3,Iris-versicolor\n6.7,3.1,4.4,1.4,Iris-versicolor\n5.6,3.0,4.5,1.5,Iris-versicolor\n5.8,2.7,4.1,1.0,Iris-versicolor\n6.2,2.2,4.5,1.5,Iris-versicolor\n5.6,2.5,3.9,1.1,Iris-versicolor\n5.9,3.2,4.8,1.8,Iris-versicolor\n6.1,2.8,4.0,1.3,Iris-versicolor\n6.3,2.5,4.9,1.5,Iris-versicolor\n6.1,2.8,4.7,1.2,Iris-versicolor\n6.4,2.9,4.3,1.3,Iris-versicolor\n6.6,3.0,4.4,1.4,Iris-versicolor\n6.8,2.8,4.8,1.4,Iris-versicolor\n6.7,3.0,5.0,1.7,Iris-versicolor\n6.0,2.9,4.5,1.5,Iris-versicolor\n5.7,2.6,3.5,1.0,Iris-versicolor\n5.5,2.4,3.8,1.1,Iris-versicolor\n5.5,2.4,3.7,1.0,Iris-versicolor\n5.8,2.7,3.9,1.2,Iris-versicolor\n6.0,2.7,5.1,1.6,Iris-versicolor\n5.4,3.0,4.5,1.5,Iris-versicolor\n6.0,3.4,4.5,1.6,Iris-versicolor\n6.7,3.1,4.7,1.5,Iris-versicolor\n6.3,2.3,4.4,1.3,Iris-versicolor\n5.6,3.0,4.1,1.3,Iris-versicolor\n5.5,2.5,4.0,1.3,Iris-versicolor\n5.5,2.6,4.4,1.2,Iris-versicolor\n6.1,3.0,4.6,1.4,Iris-versicolor\n5.8,2.6,4.0,1.2,Iris-versicolor\n5.0,2.3,3.3,1.0,Iris-versicolor\n5.6,2.7,4.2,1.3,Iris-versicolor\n5.7,3.0,4.2,1.2,Iris-versicolor\n5.7,2.9,4.2,1.3,Iris-versicolor\n6.2,2.9,4.3,1.3,Iris-versicolor\n5.1,2.5,3.0,1.1,Iris-versicolor\n5.7,2.8,4.1,1.3,Iris-versicolor\n6.3,3.3,6.0,2.5,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n7.1,3.0,5.9,2.1,Iris-virginica\n6.3,2.9,5.6,1.8,Iris-virginica\n6.5,3.0,5.8,2.2,Iris-virginica\n7.6,3.0,6.6,2.1,Iris-virginica\n4.9,2.5,4.5,1.7,Iris-virginica\n7.3,2.9,6.3,1.8,Iris-virginica\n6.7,2.5,5.8,1.8,Iris-virginica\n7.2,3.6,6.1,2.5,Iris-virginica\n6.5,3.2,5.1,2.0,Iris-virginica\n6.4,2.7,5.3,1.9,Iris-virginica\n6.8,3.0,5.5,2.1,Iris-virginica\n5.7,2.5,5.0,2.0,Iris-virginica\n5.8,2.8,5.1,2.4,Iris-virginica\n6.4,3.2,5.3,2.3,Iris-virginica\n6.5,3.0,5.5,1.8,Iris-virginica\n7.7,3.8,6.7,2.2,Iris-virginica\n7.7,2.6,6.9,2.3,Iris-virginica\n6.0,2.2,5.0,1.5,Iris-virginica\n6.9,3.2,5.7,2.3,Iris-virginica\n5.6,2.8,4.9,2.0,Iris-virginica\n7.7,2.8,6.7,2.0,Iris-virginica\n6.3,2.7,4.9,1.8,Iris-virginica\n6.7,3.3,5.7,2.1,Iris-virginica\n7.2,3.2,6.0,1.8,Iris-virginica\n6.2,2.8,4.8,1.8,Iris-virginica\n6.1,3.0,4.9,1.8,Iris-virginica\n6.4,2.8,5.6,2.1,Iris-virginica\n7.2,3.0,5.8,1.6,Iris-virginica\n7.4,2.8,6.1,1.9,Iris-virginica\n7.9,3.8,6.4,2.0,Iris-virginica\n6.4,2.8,5.6,2.2,Iris-virginica\n6.3,2.8,5.1,1.5,Iris-virginica\n6.1,2.6,5.6,1.4,Iris-virginica\n7.7,3.0,6.1,2.3,Iris-virginica\n6.3,3.4,5.6,2.4,Iris-virginica\n6.4,3.1,5.5,1.8,Iris-virginica\n6.0,3.0,4.8,1.8,Iris-virginica\n6.9,3.1,5.4,2.1,Iris-virginica\n6.7,3.1,5.6,2.4,Iris-virginica\n6.9,3.1,5.1,2.3,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n6.8,3.2,5.9,2.3,Iris-virginica\n6.7,3.3,5.7,2.5,Iris-virginica\n6.7,3.0,5.2,2.3,Iris-virginica\n6.3,2.5,5.0,1.9,Iris-virginica\n6.5,3.0,5.2,2.0,Iris-virginica\n6.2,3.4,5.4,2.3,Iris-virginica\n5.9,3.0,5.1,1.8,Iris-virginica\n\n";

    BoltConnectionIT() {
    }

    @Test
    void shouldExecuteStatement() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        BoltResponseRecorder runRecorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"CREATE (n {k:'k'}) RETURN n.k"), (BoltResponseHandler)runRecorder);
        Assertions.assertThat((Object)runRecorder.nextResponse()).satisfies(BoltConditions.succeeded());
        BoltResponseRecorder pullRecorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)pullRecorder);
        pullRecorder.nextResponse().assertRecord(0, new AnyValue[]{Values.stringValue((String)"k")});
    }

    @Test
    void shouldHandleImplicitCommitFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.run((String)"CREATE (n:Victim)-[:REL]->()"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"MATCH (n:Victim) DELETE n"), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Schema.ConstraintValidationFailed));
    }

    @Test
    void shouldAllowUserControlledRollbackOnExplicitTxFailure() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.run((String)"CREATE (n:Victim)-[:REL]->()"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.discardAll(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"this is not valid syntax"), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Statement.SyntaxError));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)machine.hasOpenStatement());
        recorder.reset();
        BoltConnectionIT.resetReceived(machine, recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)machine.hasOpenStatement());
    }

    @Test
    void shouldHandleFailureDuringResultPublishing() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        final CountDownLatch pullAllCallbackCalled = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        machine.process(BoltV4Messages.run(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV4Messages.pullAll(), new BoltResponseHandler(){

            public boolean onPullRecords(BoltResult result, long size) {
                throw new RuntimeException("Ooopsies!");
            }

            public boolean onDiscardRecords(BoltResult result, long size) {
                throw new RuntimeException("Not this one!");
            }

            public void onMetadata(String key, AnyValue value) {
            }

            public void markFailed(Neo4jError err) {
                error.set(err);
                pullAllCallbackCalled.countDown();
            }

            public void markIgnored() {
            }

            public void onFinish() {
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pullAllCallbackCalled.await(30L, TimeUnit.SECONDS));
        Neo4jError err = (Neo4jError)error.get();
        Assertions.assertThat((Object)err.status()).isEqualTo((Object)Status.General.UnknownError);
        Assertions.assertThat((String)err.message()).contains(new CharSequence[]{"Ooopsies!"});
    }

    @Test
    void shouldBeAbleToCleanlyRunMultipleSessionsInSingleThread() throws Throwable {
        BoltStateMachineV4 firstMachine = this.newStateMachineAfterAuth("conn1");
        BoltStateMachineV4 secondMachine = this.newStateMachineAfterAuth("conn2");
        firstMachine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        secondMachine.process(BoltV4Messages.run((String)"CREATE (a:Person) RETURN id(a)"), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        secondMachine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        long id = ((LongValue)response.singleValueRecord()).longValue();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        firstMachine.process(BoltV4Messages.rollback(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        recorder.reset();
        secondMachine.process(BoltV4Messages.run((String)("MATCH (a:Person) WHERE id(a) = " + id + " RETURN COUNT(*)")), (BoltResponseHandler)recorder);
        secondMachine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeededWithRecord((Object[])new Object[]{1L}));
    }

    @Test
    void shouldSupportUsingPeriodicCommitInSession() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        MapValue params = BoltConnectionIT.map("csvFileUrl", BoltConnectionIT.createLocalIrisData((BoltStateMachine)machine));
        long txIdBeforeQuery = env.lastClosedTxId();
        int batch = 40;
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)("USING PERIODIC COMMIT " + batch + "\nLOAD CSV WITH HEADERS FROM $csvFileUrl AS l\nMATCH (c:Class {name: l.class_name})\nCREATE (s:Sample {sepal_length: l.sepal_length, sepal_width: l.sepal_width, petal_length: l.petal_length, petal_width: l.petal_width})\nCREATE (c)<-[:HAS_CLASS]-(s)\nRETURN count(*) AS c"), (MapValue)params), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeededWithRecord((Object[])new Object[]{150L}));
        int tokensCommits = 7;
        int commits = (IRIS_DATA.split("\n").length - 1) / batch;
        long txId = env.lastClosedTxId();
        org.junit.jupiter.api.Assertions.assertEquals((long)((long)(tokensCommits + commits) + txIdBeforeQuery), (long)txId);
    }

    @Test
    void shouldNotSupportUsingPeriodicCommitInTransaction() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        MapValue params = BoltConnectionIT.map("csvFileUrl", BoltConnectionIT.createLocalIrisData((BoltStateMachine)machine));
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"USING PERIODIC COMMIT 40\nLOAD CSV WITH HEADERS FROM $csvFileUrl AS l\nMATCH (c:Class {name: l.class_name})\nCREATE (s:Sample {sepal_length: l.sepal_length, sepal_width: l.sepal_width, petal_length: l.petal_length, petal_width: l.petal_width})\nCREATE (c)<-[:HAS_CLASS]-(s)\nRETURN count(*) AS c", (MapValue)params), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Statement.SemanticError));
    }

    @Test
    void shouldSupportUsingExplainPeriodicCommitInTransaction() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        MapValue params = BoltConnectionIT.map("csvFileUrl", BoltConnectionIT.createLocalIrisData((BoltStateMachine)machine));
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"EXPLAIN USING PERIODIC COMMIT 40\nLOAD CSV WITH HEADERS FROM $csvFileUrl AS l\nMATCH (c:Class {name: l.class_name})\nCREATE (s:Sample {sepal_length: l.sepal_length, sepal_width: l.sepal_width, petal_length: l.petal_length, petal_width: l.petal_width})\nCREATE (c)<-[:HAS_CLASS]-(s)\nRETURN count(*) AS c", (MapValue)params), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
    }

    @Test
    void shouldCloseTransactionOnCommit() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltConnectionIT.runAndPull((BoltStateMachine)machine);
        machine.process(BoltV4Messages.commit(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
    }

    @Test
    void shouldCloseTransactionEvenIfCommitFails() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"X"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Statement.SyntaxError));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.wasIgnored());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
        recorder.reset();
        machine.process(BoltV4Messages.commit(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.wasIgnored());
        BoltConnectionIT.resetReceived(machine, recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
    }

    @Test
    void shouldCloseTransactionOnRollback() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltConnectionIT.runAndPull((BoltStateMachine)machine);
        machine.process(BoltV4Messages.rollback(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
    }

    @Test
    void shouldCloseTransactionOnRollbackAfterFailure() throws Exception {
        BoltStateMachineV4 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV4Messages.begin(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)"X"), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Statement.SyntaxError));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.wasIgnored());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
        recorder.reset();
        machine.process(BoltV4Messages.rollback(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.wasIgnored());
        BoltConnectionIT.resetReceived(machine, recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)BoltConnectionIT.hasTransaction((BoltStateMachine)machine));
    }

    private static void resetReceived(BoltStateMachineV4 machine, BoltResponseRecorder recorder) throws BoltConnectionFatality {
        machine.interrupt();
        machine.process(BoltV4Messages.reset(), (BoltResponseHandler)recorder);
    }

    private static boolean hasTransaction(BoltStateMachine machine) {
        TransactionManager txManager = ((AbstractBoltStateMachine)machine).stateMachineContext().getTransactionManager();
        return ((StatementProcessorTxManager)txManager).getCurrentNoOfOpenTx() > 0;
    }

    private static String createLocalIrisData(BoltStateMachine machine) throws Exception {
        for (String className : IRIS_CLASS_NAMES) {
            MapValue params = BoltConnectionIT.map("className", className);
            BoltConnectionIT.runAndPull(machine, "CREATE (c:Class {name: $className}) RETURN c", params);
        }
        return SessionExtension.putTmpFile((String)"iris", (String)".csv", (String)IRIS_DATA).toExternalForm();
    }

    private static void runAndPull(BoltStateMachine machine) throws Exception {
        BoltConnectionIT.runAndPull(machine, "RETURN 1", EMPTY_PARAMS);
    }

    private static void runAndPull(BoltStateMachine machine, String statement, MapValue params) throws Exception {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(BoltV4Messages.run((String)statement, (MapValue)params), (BoltResponseHandler)recorder);
        machine.process(BoltV4Messages.pullAll(), (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
    }

    private static MapValue map(Object ... keyValues) {
        return ValueUtils.asMapValue((Map)MapUtil.map((Object[])keyValues));
    }
}

