/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class CertificatesIT {
    private static Path keyFile;
    private static Path certFile;
    private static SelfSignedCertificateFactory certFactory;
    private static TransportTestUtil util;
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> {
            SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
            settings.put(policy.enabled, true);
            settings.put(policy.public_certificate, certFile.toAbsolutePath());
            settings.put(policy.private_key, keyFile.toAbsolutePath());
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        });
        this.server.init(testInfo);
    }

    @Test
    public void shouldUseConfiguredCertificate() throws Exception {
        SecureSocketConnection connection = new SecureSocketConnection();
        try {
            connection.connect(this.server.lookupConnector("bolt")).send(util.defaultAcceptedVersions());
            Set certificatesSeen = connection.getServerCertificatesSeen();
            Assertions.assertThat((Iterable)certificatesSeen).containsExactly((Object[])new X509Certificate[]{CertificatesIT.loadCertificateFromDisk()});
        }
        finally {
            connection.disconnect();
        }
    }

    private static X509Certificate loadCertificateFromDisk() throws CertificateException, IOException {
        X509Certificate[] certificates = PkiUtils.loadCertificates((Path)certFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        return certificates[0];
    }

    @BeforeAll
    public static void setup() throws IOException, GeneralSecurityException, OperatorCreationException {
        certFactory = new SelfSignedCertificateFactory();
        keyFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        certFile = Files.createTempFile("key", "pem", new FileAttribute[0]);
        Files.delete(keyFile);
        Files.delete(certFile);
        certFactory.createSelfSignedCertificate(certFile, keyFile, "my.domain");
        util = new TransportTestUtil();
    }
}

