/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.Neo4jPackV3;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v44.BoltProtocolV44;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class DateFormattingIT {
    private static final String USER_AGENT = "TestClient/4.4";
    @Inject
    public Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws IOException {
        this.server.setConfigure(Neo4jWithSocket.withOptionalBoltEncryption());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    protected void init(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.connection = connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"zoneArguments"})
    public void shouldReturnUTCFormattedZoneDates(ZonedDateTime zonedDateTime) throws Exception {
        this.init(SocketConnection.class);
        TransportTestUtil packV3Util = new TransportTestUtil((Neo4jPack)new Neo4jPackV3());
        this.negotiateBoltV44WithPatch(packV3Util);
        this.connection.send(packV3Util.chunk(new RequestMessage[]{new RunMessage("RETURN $p", DateFormattingIT.parameterMap(zonedDateTime))}));
        this.connection.send(packV3Util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue(Collections.singletonMap("n", -1L)))}));
        Assertions.assertThat((Object)this.connection).satisfies(packV3Util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{DateFormattingIT.dateTimeEquals(zonedDateTime)})), MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest
    @MethodSource(value={"offsetArguments"})
    public void shouldReturnUTCFormattedOffsetDates(ZonedDateTime zonedDateTime) throws Exception {
        this.init(SocketConnection.class);
        TransportTestUtil packV3Util = new TransportTestUtil((Neo4jPack)new Neo4jPackV3());
        this.negotiateBoltV44WithPatch(packV3Util);
        this.connection.send(packV3Util.chunk(new RequestMessage[]{new RunMessage("RETURN $p", DateFormattingIT.parameterMap(zonedDateTime))}));
        this.connection.send(packV3Util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue(Collections.singletonMap("n", -1L)))}));
        Assertions.assertThat((Object)this.connection).satisfies(packV3Util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{DateFormattingIT.dateTimeEquals(zonedDateTime)})), MessageConditions.msgSuccess()}));
    }

    @Test
    public void shouldErrorIfPatchNegotiatedButNonUTCDatesAreSent() throws Exception {
        this.init(SocketConnection.class);
        TransportTestUtil packV2Util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());
        this.negotiateBoltV44WithPatch(packV2Util);
        this.connection.send(packV2Util.chunk(new RequestMessage[]{new RunMessage("RETURN $p", DateFormattingIT.parameterMap(ZonedDateTime.now()))}));
        Assertions.assertThat((Object)this.connection).satisfies(packV2Util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure()}));
    }

    @Test
    public void shouldErrorIfPatchedDatesAreSentButNotNegotiated() throws Exception {
        this.init(SocketConnection.class);
        TransportTestUtil packV3Util = new TransportTestUtil((Neo4jPack)new Neo4jPackV3());
        this.negotiateBoltV44WithoutPatch(packV3Util);
        this.connection.send(packV3Util.chunk(new RequestMessage[]{new RunMessage("RETURN $p", DateFormattingIT.parameterMap(ZonedDateTime.now()))}));
        Assertions.assertThat((Object)this.connection).satisfies(packV3Util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure()}));
    }

    private static Stream<Arguments> zoneArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{ZonedDateTime.of(1978, 12, 16, 12, 35, 59, 128000987, ZoneId.of("Europe/Istanbul"))}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2022, 6, 14, 15, 21, 18, 183000000, ZoneId.of("Europe/Berlin"))}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2022, 6, 14, 22, 6, 18, 183000000, ZoneId.of("Australia/Eucla"))}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2020, 6, 15, 4, 30, 0, 183000000, ZoneId.of("Pacific/Honolulu"))}));
    }

    private static Stream<Arguments> offsetArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{ZonedDateTime.of(1978, 12, 16, 10, 5, 59, 128000987, ZoneOffset.ofTotalSeconds(-9000))}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2022, 6, 14, 15, 21, 18, 183000000, ZoneOffset.ofTotalSeconds(7200))}), Arguments.of((Object[])new Object[]{ZonedDateTime.of(2020, 6, 15, 12, 30, 0, 42, ZoneOffset.ofTotalSeconds(-7200))}));
    }

    private void negotiateBoltV44WithPatch(TransportTestUtil util) throws Exception {
        this.connection.connect(this.address).send(TransportTestUtil.acceptedVersions((long)BoltProtocolV44.VERSION.toInt(), (long)0L, (long)0L, (long)0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 4, 4}));
        this.connection.send(util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT, "patch_bolt", List.of("utc")}))}));
        Assertions.assertThat((Object)this.connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(msg -> Assertions.assertThat((Map)msg).containsEntry((Object)"patch_bolt", List.of("utc")))}));
    }

    private void negotiateBoltV44WithoutPatch(TransportTestUtil util) throws Exception {
        this.connection.connect(this.address).send(TransportTestUtil.acceptedVersions((long)BoltProtocolV44.VERSION.toInt(), (long)0L, (long)0L, (long)0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 4, 4}));
        this.connection.send(util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)this.connection).satisfies(util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(msg -> Assertions.assertThat((Map)msg).doesNotContainKey((Object)"patch_bolt"))}));
    }

    private static MapValue parameterMap(ZonedDateTime zonedDateTime) {
        ZonedDateTime[] dateTimes = new ZonedDateTime[]{zonedDateTime};
        return VirtualValues.map((String[])new String[]{"p"}, (AnyValue[])new AnyValue[]{Values.dateTimeArray((ZonedDateTime[])dateTimes)});
    }

    private static Condition<AnyValue> dateTimeEquals(ZonedDateTime expected) {
        return new Condition(value -> value.equals((Object)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{expected})), "Temporal equals", new Object[0]);
    }
}

