/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v42.runtime;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.StreamConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkWithDatabaseId;
import org.neo4j.bolt.v42.BoltProtocolV42;
import org.neo4j.common.DependencyResolver;
import org.neo4j.fabric.config.FabricSettings;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class BoltV42TransportIT {
    private static final String USER_AGENT = "TestClient/4.2";
    @Inject
    public Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    private static Stream<Arguments> argumentsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{SocketConnection.class}), Arguments.of((Object[])new Object[]{WebSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureWebSocketConnection.class}));
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> {
            Neo4jWithSocket.withOptionalBoltEncryption().accept(settings);
            settings.put(FabricSettings.enabled_by_default, false);
        });
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
    }

    protected void init(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.connection = connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnUpdatedBookmarkAfterAutoCommitTransaction(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV42();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(responseMessage -> Assertions.assertThat((Map)responseMessage).containsEntry((Object)"bookmark", (Object)expectedBookmark))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnUpdatedBookmarkAfterExplicitTransaction(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV42();
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = new BookmarkWithDatabaseId(lastClosedTransactionId + 1L, this.getDatabaseId()).toString();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()"), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", -1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(), MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).doesNotContainEntry((Object)"bookmark", (Object)expectedBookmark))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> Assertions.assertThat((Map)message).containsEntry((Object)"bookmark", (Object)expectedBookmark))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldStreamWhenStatementIdNotProvided(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV42();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(30, 40) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 5L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(30L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(31L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(32L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(33L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(34L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(35L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(36L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(37L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(38L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(39L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 10L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(40L)})), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"has_more"))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldSendAndReceiveStatementIds(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.init(connectionClass);
        this.negotiateBoltV42();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(1, 10) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 3L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(1L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(2L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(3L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(11, 20) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)1L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 1L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(11L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(12L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(21, 30) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)2L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 4L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(21L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(22L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(23L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(24L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(31, 40) AS x RETURN x")}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"qid", (Object)3L)).containsKeys((Object[])new String[]{"fields", "t_first"}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 1L, "qid", 3L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(31L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 2L, "qid", 0L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(4L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(5L)})), MessageConditions.msgSuccess(Collections.singletonMap("has_more", true))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 9L, "qid", 3L})))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(32L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(33L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(34L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(35L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(36L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(37L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(38L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(39L)})), MessageConditions.msgRecord((Condition)StreamConditions.eqRecord((Condition[])new Condition[]{BoltV42TransportIT.longValueCondition(40L)})), MessageConditions.msgSuccess(message -> ((MapAssert)Assertions.assertThat((Map)message).containsKey((Object)"t_last")).doesNotContainKey((Object)"has_more"))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private void negotiateBoltV42() throws Exception {
        this.connection.connect(this.address).send(TransportTestUtil.acceptedVersions((long)BoltProtocolV42.VERSION.toInt(), (long)0L, (long)0L, (long)0L));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 2, 4}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private long getLastClosedTransactionId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        TransactionIdStore txIdStore = (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    private NamedDatabaseId getDatabaseId() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.server.graphDatabaseService()).getDependencyResolver();
        Database database = (Database)resolver.resolveDependency(Database.class);
        return database.getNamedDatabaseId();
    }

    private static Condition<AnyValue> longValueCondition(long expected) {
        return new Condition(value -> value.equals((Object)Values.longValue((long)expected)), "equals", new Object[0]);
    }
}

