/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class ConnectionIT {
    @Inject
    private Neo4jWithSocket server;
    public TransportConnection connection;
    private HostnamePort address;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(Neo4jWithSocket.withOptionalBoltEncryption());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public static Stream<Arguments> transportFactory() {
        return Stream.of(Arguments.of((Object[])new Object[]{new SecureSocketConnection()}), Arguments.of((Object[])new Object[]{new SocketConnection()}), Arguments.of((Object[])new Object[]{new SecureWebSocketConnection()}), Arguments.of((Object[])new Object[]{new WebSocketConnection()}));
    }

    @ParameterizedTest(name="{displayName} {index}")
    @MethodSource(value={"transportFactory"})
    public void shouldCloseConnectionOnInvalidHandshake(TransportConnection connection) throws Exception {
        this.connection = connection;
        connection.connect(this.address);
        connection.send(new byte[]{-34, -83, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        Assertions.assertThrows(IOException.class, () -> connection.recv(4));
    }
}

