/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@ExtendWith(value={OtherThreadExtension.class})
public class ResetMessageIT {
    private static final String USER_AGENT = "TestClient/4.0";
    @Inject
    public Neo4jWithSocket server;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    private static Stream<byte[]> versionProvider() {
        return Stream.of(TransportTestUtil.acceptedVersions((long)4L, (long)0L, (long)0L, (long)0L), TransportTestUtil.acceptedVersions((long)4L, (long)1L, (long)0L, (long)0L), TransportTestUtil.acceptedVersions((long)4L, (long)2L, (long)0L, (long)0L), TransportTestUtil.acceptedVersions((long)4L, (long)3L, (long)0L, (long)0L), TransportTestUtil.acceptedVersions((long)4L, (long)4L, (long)0L, (long)0L), TransportTestUtil.acceptedVersions((long)3L, (long)0L, (long)0L, (long)0L));
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        this.server.setGraphDatabaseFactory(new TestDatabaseManagementServiceBuilder());
        this.server.setConfigure(Neo4jWithSocket.withOptionalBoltEncryption());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.connection = new SocketConnection();
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
        GraphDatabaseService gds = this.server.graphDatabaseService();
        try (Transaction tx = gds.beginTx();){
            for (int i = 30; i <= 40; ++i) {
                tx.createNode(new Label[]{Label.label((String)("L" + i))});
            }
            tx.commit();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"versionProvider"})
    void shouldResetToReadyStateWhenAuthenticated(byte[] acceptedVersion) throws Exception {
        this.connection.connect(this.address).send(acceptedVersion);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.connection.recv(4));
        this.connection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"versionProvider"})
    void shouldFailAResetWhenInUnauthenticatedStateLegacy(byte[] acceptedVersion) throws Exception {
        this.connection.connect(this.address).send(acceptedVersion);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.connection.recv(4));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
    }
}

