/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@Neo4jWithSocketExtension
public class TransactionTerminationIT {
    private TransportTestUtil util;
    private HostnamePort serverAddress;
    @Inject
    public Neo4jWithSocket server;

    @BeforeEach
    void setUp(TestInfo testInfo) throws Exception {
        TestDatabaseManagementServiceBuilder test = new TestDatabaseManagementServiceBuilder();
        this.server.setGraphDatabaseFactory(test);
        this.server.setConfigure(settings -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.listen_address, new SocketAddress(0));
        });
        this.server.init(testInfo);
        this.serverAddress = this.server.lookupConnector("bolt");
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
    }

    @Test
    @Timeout(value=15L)
    void killTxViaReset() throws Exception {
        SocketConnection connA = this.initializeConnection(this.serverAddress);
        connA.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        connA.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND range(1, 2000000) AS i CREATE (n)")}));
        this.awaitTransactionStart();
        connA.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Transaction.Terminated)}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    public void awaitTransactionStart() throws InterruptedException {
        long txCount = 1L;
        while (txCount <= 1L) {
            Transaction tx = this.server.graphDatabaseService().beginTx();
            Result result = tx.execute("SHOW TRANSACTIONS");
            txCount = result.stream().collect(Collectors.toList()).size();
            System.out.println(txCount);
            tx.close();
            Thread.sleep(100L);
        }
    }

    private SocketConnection initializeConnection(HostnamePort address) throws Exception {
        SocketConnection socketConnection = new SocketConnection();
        socketConnection.connect(address).send(TransportTestUtil.defaultAcceptedVersions());
        Assertions.assertThat((Object)socketConnection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        socketConnection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TESTCLIENT/4.2"}))}));
        Assertions.assertThat((Object)socketConnection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        return socketConnection;
    }
}

