/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.BoltV3Messages;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.runtime.BoltStateMachineV3StateTestBase;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;

class InterruptedStateIT
extends BoltStateMachineV3StateTestBase {
    InterruptedStateIT() {
    }

    @Test
    void shouldMoveReadyOnReset_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldStayInInterruptedOnMoreReset() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        machine.interrupt();
        machine.interrupt();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldStayInInterruptedOnInterruptedSignal() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException, BoltConnectionFatality {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(message, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.wasIgnored());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    private BoltStateMachineV3 getBoltStateMachineInInterruptedState() throws BoltConnectionFatality {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)InterruptedStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
        return machine;
    }

    private static Stream<RequestMessage> illegalV3Messages() {
        return BoltV3Messages.supported().filter(it -> !it.equals(BoltV3Messages.reset()));
    }
}

