/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.BoltStateMachineV3StateTestBase;
import org.neo4j.bolt.v3.runtime.FailedState;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v3.runtime.StreamingState;
import org.neo4j.kernel.api.exceptions.Status;

class StreamingStateIT
extends BoltStateMachineV3StateTestBase {
    StreamingStateIT() {
    }

    @Test
    void shouldMoveFromStreamingToReadyOnPullAll_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)PullAllMessage.INSTANCE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("type"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromStreamingToReadyOnDiscardAll_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(ReadyState.class);
    }

    @Test
    void shouldMoveFromStreamingToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"pullAllDiscardAllMessages"})
    void shouldMoveFromStreamingStateToFailedStateOnPullAllOrDiscardAll_fail(RequestMessage message) throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInStreamingState();
        BoltResponseHandler handler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onPullRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onDiscardRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        machine.process(message, handler);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(FailedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3MessagesInStreamingState(RequestMessage message) throws Throwable {
        this.shouldThrowExceptionOnIllegalMessagesInStreamingState(message);
    }

    private void shouldThrowExceptionOnIllegalMessagesInStreamingState(RequestMessage message) throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)StreamingStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(StreamingState.class);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltConditions.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Request.Invalid));
        org.junit.jupiter.api.Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() {
        return Stream.of(StreamingStateIT.newHelloMessage(), new RunMessage("any string"), new BeginMessage(), RollbackMessage.ROLLBACK_MESSAGE, CommitMessage.COMMIT_MESSAGE, ResetMessage.INSTANCE, GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private static Stream<RequestMessage> pullAllDiscardAllMessages() {
        return Stream.of(PullAllMessage.INSTANCE, DiscardAllMessage.INSTANCE);
    }

    private BoltStateMachineV3 getBoltStateMachineInStreamingState() throws BoltConnectionFatality {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)StreamingStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(StreamingState.class);
        return machine;
    }
}

