/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transaction.StatementProcessorTxManager;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public class TransactionManagerCleanupIT
extends AbstractBoltTransportsTest {
    @Inject
    private Neo4jWithSocket server;

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setConfigure(this.getSettingsFunction());
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    void shouldIncreaseAndDecreaseTxCount(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        StatementProcessorTxManager txManager = TransactionManagerCleanupIT.getStatementProcessorTxManager(this.server);
        Assertions.assertThat((int)txManager.transactionCount()).isEqualTo(0);
        this.connection.connect(this.address).send(TransportTestUtil.defaultAcceptedVersions()).send(this.util.defaultAuth()).send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion())).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}))).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((int)txManager.transactionCount()).isEqualTo(1);
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((int)txManager.transactionCount()).isEqualTo(0);
    }

    @ParameterizedTest(name="{displayName} {2}")
    @MethodSource(value={"argumentsProvider"})
    void shouldDecrementProviderCountOnConnectionClosure(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.initParameters(connectionClass, neo4jPack, name);
        StatementProcessorTxManager txManager = TransactionManagerCleanupIT.getStatementProcessorTxManager(this.server);
        Assertions.assertThat((int)txManager.statementProcessorProviderCount()).isEqualTo(0);
        this.connection.connect(this.address).send(TransportTestUtil.defaultAcceptedVersions()).send(this.util.defaultAuth());
        ((ObjectAssert)Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion())).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((int)txManager.statementProcessorProviderCount()).isEqualTo(1);
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyDisconnects());
        Assertions.assertThat((int)txManager.statementProcessorProviderCount()).isEqualTo(0);
    }

    private static StatementProcessorTxManager getStatementProcessorTxManager(Neo4jWithSocket server) {
        return (StatementProcessorTxManager)((GraphDatabaseAPI)server.graphDatabaseService()).getDependencyResolver().resolveDependency(StatementProcessorTxManager.class);
    }
}

