/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.transport.BoltMemoryPool;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.MemoryPools;

class BoltMemoryPoolIT {
    private final int requestedSize = (int)ByteUnit.kibiBytes((long)10L);

    BoltMemoryPoolIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void reportConsumedHeapMemory() {
        PooledByteBufAllocator bufAllocator = BoltMemoryPoolIT.createTestAllocator(false);
        PooledByteBufAllocatorMetric allocatorMetric = bufAllocator.metric();
        Assertions.assertEquals((long)0L, (long)allocatorMetric.usedDirectMemory());
        Assertions.assertEquals((long)0L, (long)allocatorMetric.usedDirectMemory());
        BoltMemoryPool memoryTracker = new BoltMemoryPool(new MemoryPools(), (ByteBufAllocatorMetric)allocatorMetric);
        ByteBuf buffer = bufAllocator.buffer(this.requestedSize);
        try {
            Assertions.assertEquals((int)this.requestedSize, (int)buffer.capacity());
            Assertions.assertEquals((long)this.requestedSize, (long)memoryTracker.usedHeap());
            Assertions.assertEquals((long)this.requestedSize, (long)memoryTracker.totalUsed());
        }
        finally {
            buffer.release();
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedHeap());
        Assertions.assertEquals((long)0L, (long)memoryTracker.totalUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void reportConsumedDirectMemory() {
        PooledByteBufAllocator bufAllocator = BoltMemoryPoolIT.createTestAllocator(true);
        PooledByteBufAllocatorMetric allocatorMetric = bufAllocator.metric();
        Assertions.assertEquals((long)0L, (long)allocatorMetric.usedDirectMemory());
        Assertions.assertEquals((long)0L, (long)allocatorMetric.usedDirectMemory());
        BoltMemoryPool memoryTracker = new BoltMemoryPool(new MemoryPools(), (ByteBufAllocatorMetric)allocatorMetric);
        ByteBuf buffer = bufAllocator.buffer(this.requestedSize);
        try {
            Assertions.assertEquals((int)this.requestedSize, (int)buffer.capacity());
            Assertions.assertEquals((long)this.requestedSize, (long)memoryTracker.usedNative());
            Assertions.assertEquals((long)this.requestedSize, (long)memoryTracker.totalUsed());
        }
        finally {
            buffer.release();
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNative());
        Assertions.assertEquals((long)0L, (long)memoryTracker.totalUsed());
    }

    private static PooledByteBufAllocator createTestAllocator(boolean preferDirect) {
        return new PooledByteBufAllocator(preferDirect, 1, 1, (int)ByteUnit.kibiBytes((long)4L), 1, 0, 0, 0, true);
    }
}

