/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v4.BoltProtocolV4ComponentFactory;
import org.neo4j.bolt.v4.messaging.PullMessage;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;

@TestDirectoryExtension
@Neo4jWithSocketExtension
public class ResetLockedNodeIT {
    private TransportTestUtil util;
    private HostnamePort serverAddress;
    @Inject
    public Neo4jWithSocket server;

    @BeforeEach
    void setUp(TestInfo testInfo) throws Exception {
        this.server.setGraphDatabaseFactory(new TestDatabaseManagementServiceBuilder());
        this.server.setConfigure(settings -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.listen_address, new SocketAddress(0));
        });
        this.server.init(testInfo);
        this.serverAddress = this.server.lookupConnector("bolt");
        this.util = new TransportTestUtil(BoltProtocolV4ComponentFactory.newMessageEncoder());
        SocketConnection connection = new SocketConnection();
        this.initializeConnection(connection, this.serverAddress);
        connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n {id: 123})")}));
        connection.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 100L})))}));
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
    }

    @Test
    @Timeout(value=15L)
    void shouldErrorWhenResettingAConnectionWaitingOnALock() throws Exception {
        SocketConnection connA = new SocketConnection();
        SocketConnection connB = new SocketConnection();
        this.initializeConnection(connA, this.serverAddress);
        this.initializeConnection(connB, this.serverAddress);
        connA.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        MapValueBuilder parameterValue = new MapValueBuilder();
        parameterValue.add("currentId", (AnyValue)Values.intValue((int)123));
        parameterValue.add("newId", (AnyValue)Values.intValue((int)456));
        connA.send(this.util.chunk(new RequestMessage[]{new RunMessage("MATCH (n {id: $currentId}) SET n.id = $newId", parameterValue.build())}));
        connA.send(this.util.chunk(new RequestMessage[]{new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 100L})))}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        MapValueBuilder parameterValueB = new MapValueBuilder();
        parameterValueB.add("currentId", (AnyValue)Values.intValue((int)123));
        parameterValueB.add("newId", (AnyValue)Values.intValue((int)789));
        connB.send(this.util.chunk(new RequestMessage[]{new RunMessage("MATCH (n {id: $currentId}) SET n.id = $newId", parameterValueB.build()), new PullMessage(ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"n", 100L})))}));
        Thread.sleep(300L);
        connB.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE}));
        Assertions.assertThat((Object)connB).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgFailure((Status)Status.Transaction.LockClientStopped)}));
        Assertions.assertThat((Object)connB).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgIgnored()}));
        Assertions.assertThat((Object)connB).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
        connA.send(this.util.chunk(new RequestMessage[]{CommitMessage.COMMIT_MESSAGE}));
        Assertions.assertThat((Object)connA).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }

    private void initializeConnection(SocketConnection connection, HostnamePort address) throws Exception {
        connection.connect(address).send(TransportTestUtil.defaultAcceptedVersions());
        Assertions.assertThat((Object)connection).satisfies(TransportTestUtil.eventuallyReceivesSelectedProtocolVersion());
        connection.send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TESTCLIENT/4.2"}))}));
        Assertions.assertThat((Object)connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }
}

