/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltConditions;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v3.messaging.BoltV3Messages;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.bolt.v4.messaging.BoltV4Messages;
import org.neo4j.bolt.v4.messaging.RunMessage;
import org.neo4j.bolt.v4.runtime.AutoCommitState;
import org.neo4j.bolt.v4.runtime.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.v4.runtime.FailedState;
import org.neo4j.bolt.v4.runtime.InTransactionState;
import org.neo4j.kernel.api.exceptions.Status;

class ReadyStateIT
extends BoltStateMachineV4StateTestBase {
    ReadyStateIT() {
    }

    @Test
    void shouldMoveToAutoCommitOnRun_succ() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("fields"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.hasMetadata("t_first"));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(AutoCommitState.class);
    }

    @Test
    void shouldMoveToInTransactionOnBegin_succ() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertThat((Object)response).satisfies(BoltConditions.succeeded());
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InTransactionState.class);
    }

    @Test
    void shouldMoveToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)machine.state()).isInstanceOf(InterruptedState.class);
    }

    @Test
    void shouldMoveToFailedStateOnRun_fail() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process((RequestMessage)runMessage, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.General.UnknownError));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(FailedState.class);
    }

    @Test
    void shouldMoveToFailedStateOnBegin_fail() throws Throwable {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BeginMessage beginMessage = (BeginMessage)Mockito.mock(BeginMessage.class);
        Mockito.when((Object)beginMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)beginMessage.bookmarks()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process((RequestMessage)beginMessage, (BoltResponseHandler)recorder);
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.General.UnknownError));
        Assertions.assertThat((Object)machine.state()).isInstanceOf(FailedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV2Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException, BoltConnectionFatality {
        BoltStateMachineV4 machine = this.newStateMachine();
        machine.process(ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltConditions.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        Assertions.assertThat((Object)recorder.nextResponse()).satisfies(BoltConditions.failedWithStatus((Status)Status.Request.Invalid));
        org.junit.jupiter.api.Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV4Messages() throws BoltIOException {
        return Stream.of(BoltV4Messages.hello(), BoltV4Messages.pullAll(), BoltV4Messages.discardAll(), BoltV4Messages.commit(), BoltV4Messages.rollback(), BoltV4Messages.goodbye());
    }

    private static Stream<RequestMessage> illegalV3Messages() {
        return Stream.of(BoltV3Messages.run(), BoltV3Messages.begin(), BoltV3Messages.discardAll(), BoltV3Messages.pullAll());
    }
}

